% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeQuantileSimulationSurface.R
\name{makeQuantileSimulationSurface}
\alias{makeQuantileSimulationSurface}
\title{Create quantile-simulation surfaces}
\usage{
makeQuantileSimulationSurface(probabilitySurface, ValidationQuantiles,
  rename = FALSE, rescale = TRUE)
}
\arguments{
\item{probabilitySurface}{Normalized probability surface RasterLayer.}

\item{ValidationQuantiles}{Vector of quantile values from known-origin individuals, against which to compare each value within the probability surface. Each value must be between 0 and 1.}

\item{rename}{Character value to append to raster name (e.g. "_quantileSimulation"). Defaults to FALSE.}

\item{rescale}{If rescale = TRUE, returns surface showing proportion of times each surface cell value fell within the validation quantiles distribution. If rescale = FALSE, returns discrete number of times the cell fell within the distribution.}
}
\value{
Returns RasterLayer rescaled to quantile values.
}
\description{
Converts normalized probability surfaces (e.g. one layer output of
isotopeAssignmentModel function) to quantile surfaces.
}
\examples{
# Generate example probability surfaces.
library
myiso <- raster::rasterFromXYZ(isoscape)
myiso_sd <- raster::rasterFromXYZ(isoscape_sd)
df <- data.frame(
         ID = c(-100, -80, -50),
         isotopeValue = c(-100, -80, -50),
         SD_indv = rep(5, 3)
         )
assignmentModels <- isotopeAssignmentModel(
         ID = df$ID,
         isotopeValue = df$isotopeValue,
         SD_indv = df$SD_indv,
         precip_raster = myiso,
         precip_SD_raster = myiso_sd
         )

# Example known-origin quantile data.
q <- rweibull(20000, 6, .98)
q <- sample( q[ q >=0 & q <= 1 ], 10000, replace = TRUE)
hist(q)

# Convert to quantile surfaces.
quantileSimulation_surface <-  raster::stack(
                  lapply(
                            unstack(assignmentModels),
                            makeQuantileSimulationSurface,
                            ValidationQuantiles = q)
                        )
plot(quantileSimulation_surface)

}
