% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d18O.R
\name{temp_d18O}
\alias{temp_d18O}
\title{Oxygen isotope thermometry}
\usage{
temp_d18O(d18O_c_VSMOW, d18O_H2O_VSMOW, min, eq)
}
\arguments{
\item{d18O_c_VSMOW}{Carbonate d18O value expressed on the VSMOW scale (‰).}

\item{d18O_H2O_VSMOW}{Water d18O value expressed on the VSMOW scale (‰).}

\item{min}{Mineralogy. Options are as in \code{\link[=a18_c_H2O]{a18_c_H2O()}}.}

\item{eq}{Equation used for the calculations.
Options depend on mineralogy and listed in \code{\link[=a18_c_H2O]{a18_c_H2O()}}.}
}
\value{
Returns the carbonate growth temperature (°C).
}
\description{
\code{temp_d18O()} calculates carbonate growth temperature
from oxygen isotope data.
}
\note{
Use \code{\link[=to_VSMOW]{to_VSMOW()}} and \code{\link[=to_VPDB]{to_VPDB()}} to convert between the
VSMOW and VPDB scales.
}
\examples{
temp_d18O(d18O_c_VSMOW = 14.58, d18O_H2O_VSMOW = -13.54,
          min = "calcite", eq = "Coplen07")

}
\references{
References are listed in the description of \code{\link[=a18_c_H2O]{a18_c_H2O()}}.
}
\seealso{
\code{\link[=d18O_c]{d18O_c()}} calculates the equilibrium d18O value of a carbonate
grown at a given temperature.

\code{\link[=d18O_H2O]{d18O_H2O()}} calculates the d18O value of the ambient water
from the d18O value of a carbonate and its growth temperature.

Other thermometry: 
\code{\link{temp_D47}()},
\code{\link{temp_D48}()}
}
\concept{thermometry}
