% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{orbi_filter_satellite_peaks}
\alias{orbi_filter_satellite_peaks}
\title{Filter to remove minor satellite peaks}
\usage{
orbi_filter_satellite_peaks(dataset)
}
\arguments{
\item{dataset}{A data frame or tibble produced from IsoX data by \code{orbi_simplify_isox()}}
}
\value{
Filtered data frame (tibble)
}
\description{
Remove minor signals (e.g., satellite peaks) that were reported by IsoX
}
\details{
The \code{orbi_filter_satellite_peaks()} function removes minor signals for an isotopocule that have been reported by IsoX.
These are often small \verb{satellite peaks} generated by the Fourier transform.

If there are signal of high intensity or very many signals, this can indicate that the m/z and tolerance setting used for processing .raw files with IsoX were incorrect.
}
\examples{
fpath <- system.file("extdata", "testfile_flow.isox", package = "isoorbi")
df <- orbi_read_isox(file = fpath) \%>\%
orbi_simplify_isox() \%>\%
orbi_filter_satellite_peaks()

}
