% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/triangle_phase.R
\docType{methods}
\name{triangle_phase_cas}
\alias{triangle_phase_cas}
\alias{triangle_phase_ceramic}
\title{Ceramic Phase Diagram}
\usage{
triangle_phase_cas(labels = TRUE, symbol = FALSE, mol = FALSE, ...)

triangle_phase_ceramic(labels = TRUE, symbol = FALSE, mol = FALSE, ...)
}
\arguments{
\item{labels}{A \code{\link{logical}} scalar: should labels be displayed?}

\item{symbol}{A \code{\link{logical}} scalar: should symbol be used instead of full
labels? Only used if \code{labels} is \code{TRUE}.}

\item{mol}{A \code{\link{logical}} scalar: should molarity be used instead of molar
mass?}

\item{...}{Further arguments to be passed to \code{\link[graphics:polygon]{graphics::polygon()}}.}
}
\description{
Ceramic Phase Diagram
}
\examples{
## Ceramic phase diagram
ternary_plot(NULL, xlab = "CaO", ylab = "Al2O3", zlab = "SiO2")
triangle_phase_ceramic(symbol = TRUE, mol = TRUE, pch = 16)

ternary_plot(NULL, xlab = "CaO", ylab = "Al2O3", zlab = "SiO2")
triangle_phase_ceramic(symbol = TRUE, mol = FALSE, pch = 16)

## CAS diagram
ternary_plot(NULL, axes = FALSE, ann = FALSE, frame.plot = TRUE)
triangle_phase_cas(mol = FALSE, pch = 16)
}
\seealso{
Other charts: 
\code{\link{triangle_soil}}
}
\author{
N. Frerebeau
}
\concept{charts}
