% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui_others.R
\name{delta2prop}
\alias{delta2prop}
\title{Convert delta notation to proportion of heavy isotope}
\usage{
delta2prop(x = NULL, Rstandard = NULL)
}
\arguments{
\item{x}{Vector of delta values}

\item{Rstandard}{String describing the isotopic measurement, e.g. "d15N",
"d13C" and used to set automatically Rstandards (see the Section
"Ratios for reference standards" for more details). Alternatively, a
numeric value to use for Rstandard, e.g. 0.0036765.}
}
\value{
A vector of same length of x, containing the proportion (numeric
    between 0 and 1) of heavy isotope based on the delta values and the
    Rstandard provided.
}
\description{
For details and references about quantities used in expressing isotopic
ratios, see:
}
\details{
- Figure 1 in Coplen, Tyler B. “Guidelines and Recommended Terms for
Expression of Stable-Isotope-Ratio and Gas-Ratio Measurement Results.” Rapid
Communications in Mass Spectrometry 25, no. 17 (September 15, 2011):
2538–60. https://doi.org/10.1002/rcm.5129.

- Table 2.1 in Fry, Brian. Stable Isotope Ecology. New York:
Springer-Verlag, 2006. //www.springer.com/gp/book/9780387305134.
}
\section{Ratios for reference standards}{


The ratios for reference standards are taken from the Table 2.1 from Fry
2006. Note that the values used for oxygen isotopes are from the standard
mean ocean water (SMOW).

Standards recognized by this function are: \code{c("d15N", "d2H", "d13C",
"d17O.SMOW", "d18O.SMOW", "d33S", "d34S", "d36S")}
}

\examples{
deltas <- c(78, 5180, 263, 1065, NA, 153, 345)

# Rstandard can be specified with a string for some preset references
prop15N <- delta2prop(deltas, "d15N")
prop13C <- delta2prop(deltas, "d13C")

# Rstandard can also be specified manually for non-preset references
prop15N_manual <- delta2prop(deltas, 0.0036765)
prop13C_manual <- delta2prop(deltas, 0.011180)

# Call delta2prop() to get the detail of available references
delta2prop()

}
