% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/acf.n.plots.R
\name{acf_n_plots}
\alias{acf_n_plots}
\title{Generate N ACF plots of individual or aggregated time series.}
\usage{
acf_n_plots(x, n = 5, split_by = NULL, cond = NULL, max_lag = NULL,
  fun = mean, plot = TRUE, random = F, mfrow = NULL, add = FALSE, ...)
}
\arguments{
\item{x}{A vector with time series data, typically residuals of a
regression model.}

\item{n}{The number of plots to generate.}

\item{split_by}{List of vectors (each with equal length as \code{x}) that
group the values of \code{x} into trials or timeseries events.
Generally other columns from the same data frame.}

\item{cond}{Named list with a selection of the time series events
specified in \code{split_by}. Default is NULL, indicating that
all time series are being processed, rather than a selection.}

\item{max_lag}{Maximum lag at which to calculate the acf.
Default is the maximum for the longest time series.}

\item{fun}{The function used when aggregating over time series
(depending on the value of \code{split_by}).}

\item{plot}{Logical: whether or not to produce plot. Default is TRUE.}

\item{random}{Logical: determine randomly which \code{n} (aggregated) time
series are plotted, or use the \code{\link{quantile}} function to find a
range of different time series to plot. Default is FALSE (not random).}

\item{mfrow}{A vector of the form c(nr, nc). The figures will be drawn in
an nr-by-nc array on the device by rows.}

\item{add}{Logical: whether to add the plots to an exiting plot window or
not.
Default is FALSE.}

\item{...}{Other arguments for plotting, see \code{\link[graphics]{par}}.}
}
\value{
\code{n} ACF plots providing information about the autocorrelation
in \code{x}.
}
\description{
Generate N ACF plots of individual or aggregated time series.
}
\examples{
data(simdat)
# Separate ACF for each time series:
acf_n_plots(simdat$Y, split_by=list(simdat$Subject, simdat$Trial))
# Average ACF per participant:
acf_n_plots(simdat$Y, split_by=list(simdat$Subject))
\dontrun{
# Data treated as single time series. Plot is added to current window.
# Note: 1 time series results in 1 plot.
acf_n_plots(simdat$Y, add=TRUE)
# Plot 4 ACF plots doesn't work without splitting data:
acf_n_plots(simdat$Y, add=TRUE, n=4)

# Plot ACFs of 4 randomly selected time series:
acf_n_plots(simdat$Y, random=TRUE, n=4, add=TRUE,
    split_by=list(simdat$Subject, simdat$Trial))

}
# see the vignette for examples:
vignette("acf", package="itsadug")

#---------------------------------------------
# When using model residuals
#---------------------------------------------
\dontrun{
# add missing values to simdat:
simdat[sample(nrow(simdat), 15),]$Y <- NA
# simple linear model:
m1 <- lm(Y ~ Time, data=simdat)

# This will generate an error:
# acf_n_plots(resid(m1), split_by=list(simdat$Subject, simdat$Trial))

# This should work:
el.na <- missing_est(m1)
acf_n_plots(resid(m1),
     split_by=list(simdat[-el.na,]$Subject, simdat[-el.na,]$Trial))

# This should also work:
simdat$res <- NA
simdat[!is.na(simdat$Y),]$res <- resid(m1)
acf_n_plots(simdat$res, split_by=list(simdat$Subject, simdat$Trial))
}
}
\author{
Jacolien van Rij, R. Harald Baayen
}
\seealso{
Use \code{\link[stats]{acf}} for the original ACF function,
and \code{\link{acf_plot}} for an ACF that takes into account time series
in the data.

Other functions for model criticism: \code{\link{acf_plot}};
  \code{\link{acf_resid}}; \code{\link{check_normaldist}};
  \code{\link{resid.gam}}, \code{\link{resid_gam}}
}

