% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acf.R
\name{start_value_rho}
\alias{start_value_rho}
\title{Extract the Lag 1 value from the ACF of the residuals of a gam, bam, lm, 
lmer model, ...}
\usage{
start_value_rho(model, plot = FALSE, lag = 2, main = NULL, ...)
}
\arguments{
\item{model}{A regression model generated by \code{lm}, \code{glm},
\code{lmer}, \code{glmer}, \code{\link[mgcv]{gam}}, 
or \code{\link[mgcv]{bam}}.
(See examples for how to avoid errors due to missing values.)}

\item{plot}{Logical: whether or not to produce plot. Default is TRUE.}

\item{lag}{Numeric value, indicating the lag. Default is 2.}

\item{main}{Text string, title of ACF plot.}

\item{...}{Other arguments for plotting the acf, see 
\code{\link[stats]{acf}}.}
}
\value{
The autocorrelation value of data points with the data points 
at lag \code{lag}.
}
\description{
Wrapper around \code{\link{acf_plot}} for regression models.
}
\examples{
data(simdat)

# add missing values to simdat:
simdat[sample(nrow(simdat), 15),]$Y <- NA

\dontrun{
# Run GAMM model:
m1 <- bam(Y ~ te(Time, Trial)+s(Subject, bs='re'), data=simdat)

# No plotting:
start_value_rho(m1)
# With plot:
rhom1 <- start_value_rho(m1, plot=TRUE)

}
# see the vignette for examples:
vignette("acf", package="itsadug")
}
\author{
Jacolien van Rij
}
\seealso{
Use \code{\link[stats]{acf}} for the original ACF function, 
and \code{\link{acf_plot}}, or \code{\link{acf_resid}}.

Other functions for model criticism: \code{\link{acf_n_plots}},
  \code{\link{acf_plot}}, \code{\link{acf_resid}},
  \code{\link{derive_timeseries}}, \code{\link{resid_gam}},
  \code{\link{start_event}}
}

