% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.EnvironmentalOutlier}
\alias{print.EnvironmentalOutlier}
\title{Print summary information from PAConversion object.}
\usage{
\method{print}{EnvironmentalOutlier}(x, ...)
}
\arguments{
\item{x}{(\code{EnvironmentalOutlier}) A \code{EnvironmentalOutlier} object to be messaged.
It could be the return of function \code{\link{suspicious_env_outliers}}.}

\item{...}{Not used.}
}
\value{
The same object that was passed as input.
}
\description{
Display the most general and informative characteristics of
a PAConversion object.
}
\examples{
\donttest{
library(dplyr)
library(sf)
library(stars)
library(itsdm)

data("occ_virtual_species")
env_vars <- system.file(
  'extdata/bioclim_tanzania_10min.tif',
  package = 'itsdm') \%>\% read_stars() \%>\%
  slice('band', c(1, 5, 12, 16))

occ_outliers <- suspicious_env_outliers(
  occ = occ_virtual_species, variables = env_vars,
  z_outlier = 5, outliers_print = 4L)

print(occ_outliers)
}

}
\seealso{
\code{\link{suspicious_env_outliers}}, \code{\link{plot.EnvironmentalOutlier}}
}
