% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logit.R
\name{logit}
\alias{logit}
\title{Generalized logit function}
\usage{
logit(x, min = 0, max = 1)
}
\arguments{
\item{x}{value(s) to be transformed}

\item{min}{Lower end of logit interval}

\item{max}{Upper end of logit interval}
}
\value{
y Transformed value(s).
}
\description{
Compute generalized logit function.
}
\details{
The generalized logit function takes values on [min, max] and transforms them to span [-Inf,Inf] it is defined as:
\deqn{y = log(\frac{p}{(1-p)})}{y = log(p/(1-p))} 
\deqn{where}
\deqn{p=\frac{(x-min)}{(max-min)}}{p=(x-min)/(max-min)}
}
\examples{
x <- seq(0,10, by=0.25)
xt <- jSDM::logit(x, min=0, max=10)
cbind(x,xt)
y <- jSDM::inv_logit(xt, min=0, max=10)
cbind(x,xt,y)  
}
\author{
{Gregory R. Warnes <greg@warnes.net>}
}
\keyword{logistic}
\keyword{logit}
\keyword{math}
