% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mevo.R
\name{site_var}
\alias{site_var}
\title{Specify variation in mutation rates among sites}
\usage{
site_var(reference, shape = NULL, region_size = NULL, invariant = 0,
  mats = NULL, out_prefix = NULL, compress = FALSE,
  comp_method = "bgzip")
}
\arguments{
\item{reference}{A \code{ref_genome} object from which you will eventually
generate variants.}

\item{shape}{Shape parameter for the Gamma distribution that generates gamma distances,
The variance of the distribution is \code{1 / shape}, and its mean is fixed to 1.
Values \code{<= 0} are not allowed.
Defaults to \code{NULL}.}

\item{region_size}{Size of regions to break the genome into,
where all sites within a region have the same gamma distance.
Defaults to \code{NULL}.}

\item{invariant}{Proportion of regions that are invariant.
Must be in range \code{[0,1)}.
Defaults to \code{0}.}

\item{mats}{List of matrices, one for each sequence in the genome.
Each matrix should have two columns.
The first should contain the end points for each region.
The second should contain the gamma distances for each region.
Note that if gamma distances don't have a mean (weighted by
sequence length for each gamma-distance value) equal to 1,
you're essentially changing the overall mutation rate.
If this argument is provided, \code{shape} and \code{region_size} are ignored.
Defaults to \code{NULL}.}

\item{out_prefix}{String specifying the file name prefix for an output BED file that
will be generated by this function and that will specify the
gamma distances for each region.
If \code{NULL}, no output file is produced.
Defaults to \code{NULL}.}

\item{compress}{Logical specifying whether or not to compress output file, or
an integer specifying the level of compression, from 1 to 9.
If \code{TRUE}, a compression level of \code{6} is used.
Defaults to \code{FALSE}.}

\item{comp_method}{Character specifying which type of compression to use if any
is desired. Options include \code{"gzip"} and \code{"bgzip"}.
This is ignored if \code{compress} is \code{FALSE}. Defaults to \code{"bgzip"}.}
}
\value{
A \code{site_var_mats} object, which is a wrapper around a list of matrices,
one for each sequence in the reference genome.
Although the print method is different, you can otherwise treat these objects
the same as you would a list (e.g., \code{x[[1]]}, \code{x[1:2]}, \code{length(x)}).
}
\description{
Construct necessary information for among-site variation in mutation rates that will
be used in \code{create_variants}.
}
\details{
A site's deviance from the average mutation rate is determined by its
"gamma distance".
A site's overall mutation rate is the mutation rate for that nucleotide
(substitution + indel) multiplied by the site's gamma distance.
There are two options for specifying gamma distances:
\enumerate{
\item Generate gamma distances from a Gamma distribution.
This method will be used if the \code{shape} and \code{region_size} arguments
are provided.
If the \code{mats} argument is also provided, this method will NOT be used.
See argument descriptions for more info.
\item Manually input matrices that specify the gamma distance and end points
for regions each gamma distance refers to.
This method will be used if the \code{mats} argument is provided.
See argument descriptions for more info.
}
}
\examples{
ref <- create_genome(3, 100)
# generating from Gamma distribution
gamma_mats <- site_var(ref, shape = 0.5,
                       region_size = 5)
# with custom matrices
gamma_mats <- site_var(ref,
                       mats = replicate(3,
                           cbind(seq(10, 100, 10),
                           rgamma(10, 0.9)),
                           simplify = FALSE))

}
