% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/data.R
\name{getProblems}
\alias{getProblems}
\title{Get names of analyzed problems}
\usage{
getProblems(data, filter, ...)
}
\arguments{
\item{data}{data object containing the analysis results}

\item{filter}{\link{regular expression} (optional). Only problem names that
match the given regex are returned, if any.}

\item{...}{any additional arguments are passed to \code{\link{grep}}.}
}
\value{
Sorted vector of strings containing the names of all analyzed
  problems that occur in the given data and match the applied filter (if
  any).
}
\description{
Extracts the names of the problems for which analysis results are contained
in the given data. This is a generic S3 method.
}
\details{
Problem names are sorted using \link[naturalsort]{naturalsort}. If a
\code{filter} is set, only those problem names matching the given
\link{regular expression} are returned (pattern matching is done with
\code{\link{grep}}).
}

