% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adorn_crosstab.R
\name{adorn_crosstab}
\alias{adorn_crosstab}
\title{Add presentation formatting to a crosstabulation table.}
\usage{
adorn_crosstab(dat, denom = "row", show_n = TRUE, digits = 1,
  show_totals = FALSE, rounding = "half to even")
}
\arguments{
\item{dat}{a data.frame with row names in the first column and numeric values in all other columns.  Usually the piped-in result of a call to  \code{crosstab} that included the argument \code{percent = "none"}.}

\item{denom}{the denominator to use for calculating percentages.  One of "row", "col", or "all".}

\item{show_n}{should counts be displayed alongside the percentages?}

\item{digits}{how many digits should be displayed after the decimal point?}

\item{show_totals}{display a totals summary? Will be a row, column, or both depending on the value of \code{denom}.}

\item{rounding}{method to use for truncating percentages - either "half to even", the base R default method, or "half up", where 14.5 rounds up to 15.}
}
\value{
Returns a data.frame.
}
\description{
Formats a data.frame containing counts of co-occurrences of two variables (i.e., a contingency table or crosstab).  Adds a mix of percentages, Ns, totals row/column, and custom rounding to a table of integer counts, in the style of a Microsoft Excel PivotTable.  The result is no longer clean data, but is an audience-friendly way to report results.

Designed to run on the output of a call to \code{janitor::crosstab}, but can be called on any data.frame containing a contingency table, e.g., the result of \code{dplyr::count()} followed by \code{tidyr::spread()}.
}
\examples{
mtcars \%>\%
 crosstab(gear, cyl) \%>\%
 adorn_crosstab(denom = "all")
 
# showing with all parameters
mtcars \%>\%
 crosstab(gear, cyl) \%>\%
 adorn_crosstab(., denom = "col", rounding = "half up", show_n = FALSE, digits = 2)
mtcars \%>\%
 crosstab(cyl, am) \%>\%
 adorn_crosstab(., denom = "all", digits = 0, rounding = "half up") 
}
