% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-helpers.R
\name{jlme-model-reexports}
\alias{jlme-model-reexports}
\alias{propertynames}
\alias{issingular}
\alias{likelihoodratiotest}
\title{Re-exported functions for interacting with Julia model objects}
\usage{
propertynames(x)

issingular(x)

likelihoodratiotest(x, ...)
}
\arguments{
\item{x}{Julia model object}

\item{...}{Additional arguments passed to the Julia function}
}
\value{
An appropriate R or Julia object
}
\description{
Re-exported functions for interacting with Julia model objects
}
\examples{
\dontshow{if (check_julia_ok()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
jlme_setup(restart = TRUE)

x <- jlmer(r2 ~ Anger + (1 | id), lme4::VerbAgg, family = "binomial")

# `propertynames()` lists properties accessible via `$`
propertynames(x)

# `issingular()` reports whether model has singular fit
issingular(x)

# `likelihoodratiotest()` conducts a likelihood-ratio test between nested models
likelihoodratiotest(
  x,
  jlmer(r2 ~ 1 + (1 | id), lme4::VerbAgg, family = "binomial")
)

stop_julia()
}
\dontshow{\}) # examplesIf}
}
