% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/threshold_search.R
\name{walk_threshold_steps}
\alias{walk_threshold_steps}
\title{Test the probability of cluster-mass statistics over a range of threshold values}
\usage{
walk_threshold_steps(
  empirical_statistics,
  null_statistics,
  steps,
  top_n = Inf,
  binned = FALSE,
  add1 = TRUE,
  progress = TRUE
)
}
\arguments{
\item{empirical_statistics}{A predictor-by-time matrix of empirical timewise statistics.}

\item{null_statistics}{A simulation-by-time-by-predictor 3D array of null (permuted) timewise statistics.}

\item{steps}{A vector of threshold values to test}

\item{top_n}{How many clusters to return, in the order of the size of the cluster-mass statistic.
Defaults to \code{Inf} which return all detected clusters.}

\item{binned}{Whether the data has been aggregated/collapsed into time bins. Defaults to \code{FALSE},
which requires a cluster to span at least two time points. If \code{TRUE}, allows length-1 clusters to exist.}

\item{add1}{Whether to add 1 to the numerator and denominator when calculating the p-value.
Use \code{TRUE} to effectively count the observed statistic as part of the permuted
null distribution (recommended with larger \code{nsim} prior to publishing results).}

\item{progress}{Whether to display a progress bar}
}
\value{
A data frame of predictor clusters-mass statistics by threshold.
}
\description{
Test the probability of cluster-mass statistics over a range of threshold values
}
\examples{
\dontshow{if (julia_setup_ok()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
\dontshow{
options("jlmerclusterperm.nthreads" = 2)
jlmerclusterperm_setup(verbose = FALSE)
julia_progress(show = FALSE)
}

library(dplyr, warn.conflicts = FALSE)

# Specification object
spec <- make_jlmer_spec(
  weight ~ 1 + Diet, filter(ChickWeight, Time <= 20),
  subject = "Chick", time = "Time"
)
spec

# Compute timewise statistics for the observed and permuted data
empirical_statistics <- compute_timewise_statistics(spec)
reset_rng_state()
null_statistics <- permute_timewise_statistics(spec, nsim = 100)

# Test cluster mass/probability under different threshold values
walk_threshold_steps(empirical_statistics, null_statistics, steps = 1:3,
                     progress = FALSE)

\dontshow{
JuliaConnectoR::stopJulia()
}
}
\dontshow{\}) # examplesIf}
}
