% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aplsm.R
\name{aplsm}
\alias{aplsm}
\title{The Attribute Person Latent Space model}
\usage{
aplsm(Niter, Y.i, Y.ia, D, type)
}
\arguments{
\item{Niter}{number of iterations}

\item{Y.i}{N by N matrix containing the binary social network}

\item{Y.ia}{N by M matrix containing the binary multivariate attributes}

\item{D}{number of dimensions in the data}

\item{type}{character indicating the types of model. It could be "DD", distance by distance model, "DV", distance by vector model,
"VV", vector by vector model}
}
\value{
list containing:
 \itemize{
 \item \code{lsmhEZ.i} (\code{N} x \code{D}) matrix containing the posterior means of the latent person positions
 \item \code{lsmhEZ.a} (\code{M} x \code{D}) matrix containing the posterior means of the latent item positions
 \item \code{lsmhVZ.0} (\code{D} x \code{D}) matrix containing the posterior variance of the latent person positions
 \item \code{lsmhVZ.1} (\code{D} x \code{D}) matrix containing the posterior variance of the latent item positions
 \item \code{lsmhAlpha.0} scaler of mean of the posterior distributions of \eqn{\alpha.0}
 \item \code{lsmhAlpha.1} scaler of mean of the posterior distributions of \eqn{\alpha.1}
 \item \code{lsmhKL} expected log-likelihood
 }
}
\description{
Jointly model social network with multivariate attributes
}
\examples{
attach(french)
a=aplsm(Niter=5,Y.i, Y.ia, D=2, type="DD")
}
