% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{find_discords_rra}
\alias{find_discords_rra}
\title{Finds a discord with RRA (Rare Rule Anomaly) algorithm.
Usually works the best with higher than that for HOT-SAX sizes of discretization parameters
(i.e., PAA and Alphabet sizes).}
\usage{
find_discords_rra(series, w_size, paa_size, a_size, nr_strategy, n_threshold,
  discords_num)
}
\arguments{
\item{series}{the input timeseries.}

\item{w_size}{the sliding window size.}

\item{paa_size}{the PAA size.}

\item{a_size}{the alphabet size.}

\item{nr_strategy}{the numerosity reduction strategy ("none", "exact", "mindist").}

\item{n_threshold}{the normalization threshold.}

\item{discords_num}{the number of discords to report.}
}
\description{
Finds a discord with RRA (Rare Rule Anomaly) algorithm.
Usually works the best with higher than that for HOT-SAX sizes of discretization parameters
(i.e., PAA and Alphabet sizes).
}
\examples{
discords = find_discords_rra(ecg0606, 100, 4, 4, "none", 0.01, 1)
plot(ecg0606, type = "l", col = "cornflowerblue", main = "ECG 0606")
lines(x=c(discords[1,2]:(discords[1,2]+100)),
   y=ecg0606[discords[1,2]:(discords[1,2]+100)], col="red")
}
\references{
Senin Pavel and Malinchik Sergey,
SAX-VSM: Interpretable Time Series Classification Using SAX and Vector Space Model.,
Data Mining (ICDM), 2013 IEEE 13th International Conference on.
}
