#' Fitted \code{jointmeta1} object
#'
#' An object returned by the \code{jointmeta1} function, inheriting from class
#' \code{jointmeta1} and representing a fitted joint model for a single
#' longitudinal and a single time-to-event outcome for data from multiple
#' studies.  Objects of this class have methods for the generic functions
#' \code{\link{confint}}, \code{\link{fixef}}, \code{\link{formula}} and
#' \code{\link{ranef}}. Additionally \code{\link[joineRmeta]{rancov}} allows
#' the user to extract the estimated covariance matrices for the zero mean
#' random effects.
#'
#' @author Maria Sudell (\email{mesudell@@liverpool.ac.uk})
#' @seealso \code{\link{jointmeta1}}.
#' @return A list with the following components. \describe{
#'
#'   \item{\code{coefficients}}{a list with the estimated coefficients. The
#'   components of this list are: \describe{
#'
#'   \item{\code{fixed}}{the list of fixed effects for sub-models contained in
#'   the joint model.  The components of this list are: \describe{
#'
#'   \item{\code{longitudinal}}{a data frame containing the estimated fixed
#'   effect coefficients from the longitudinal sub-model}
#'
#'
#'   \item{\code{survival}}{a numeric vector containing the estimated fixed
#'   effect coefficients from the longitudinal sub-model}}}
#'
#'   \item{\code{random}}{the list of estimates random effects estimated by the
#'   joint model.  The components of this list are: \describe{
#'
#'   \item{\code{random_ind}}{a list of matrices of length equal to the number
#'   of studies in the dataset.  Each matrix has number of columns equal to the
#'   number of individual level random effects, and number of rows equal to the
#'   number of individuals in the study.  As \code{jointmeta1} insists on the
#'   presence of random effects at the individual level, this item will always
#'   be present.}
#'
#'   \item{\code{random_stud}}{a matrix with number of columns equal to the
#'   number of study level random effects, number of rows equal to the number of
#'   studies in the dataset.  This item is only present if study level random
#'   effects are specified in the model fit.}}}
#'
#'   \item{\code{latent}}{a numeric containing the estimates of the latent
#'   association parameters for each level of the random effects.  The
#'   association parameter for the individual level random effects is labelled
#'   \code{gamma_ind_0}, and for the study level random effects is labelled
#'   \code{gamma_stud_0}.}}}
#'
#'   \item{\code{sigma.e}}{a numeric holding the estimate of the variance of the
#'   measurement error variance}
#'
#'   \item{\code{rand_cov}}{a list containing the covariance matrices for the
#'   random effects included in the model.  The covariance matrix for the
#'   individual level random effects is labelled \code{D}.  If study level
#'   random effects are included in the model, the covariance matrix for the
#'   study level random effects is also included in the list, labelled
#'   \code{A}.}
#'
#'   \item{\code{hazard}}{if \code{strat = FALSE} in the function call for
#'   \code{jointmeta1} then this is a numeric vector containing the common
#'   baseline across all studies.  If \code{strat = TRuE} then this is a list of
#'   numeric vectors, each of which is the baseline hazard for each study in the
#'   dataset.}
#'
#'   \item{\code{loglik}}{a list containing the overall likelihood for the joint
#'   model (labelled \code{jointlhood}), and the portions of the likelihood
#'   attributable to each sub-model (\code{jointy} for the longitudinal
#'   component and \code{jointn} for the survival component).}
#'
#'   \item{\code{numIter}}{the number of EM algorithm iterations completed
#'   during the fitting of the joint model}
#'
#'   \item{\code{convergence}}{a logical value, takes a value of \code{TRUE} if
#'   convergence was achieved within the set maximum number of iterations,
#'   \code{FALSE} otherwise.}
#'
#'   \item{\code{sharingstrct}}{a character string denoting the specified
#'   sharing structure used in the joint model.  Currently only
#'   \code{'randprop'} is supported, denoting zero mean random effects sharing
#'   structure (see Wulfsohn and Tsiatis (1997)).}
#'
#'   \item{\code{sepests}}{A list containing estimates from the separate
#'   longitudinal and survival analyses.  If separate results are not requested,
#'   the elements of the list are set to 'No separate results requested'.
#'   However, if separate analyses are requested in the \code{jointmeta1}
#'   function call, the components of this list are: \describe{
#'
#'   \item{\code{longests}}{a list containing estimates from the initial
#'   longitudinal fit.  The components of this list are: \describe{
#'
#'   \item{\code{beta1}}{a data frame of the estimates of the fixed effects from
#'   the longitudinal sub-model}
#'
#'   \item{\code{sigma.e}}{the value of the variance of the measurement error
#'   from the longitudinal sub-model}
#'
#'   \item{\code{D}}{the estimate of the covariance matrix for the individual
#'   level random effects.  Individual level random effects are always included
#'   in the joint model}
#'
#'   \item{\code{A}}{the estimate of the covariance matrix for the study level
#'   random effects.  This is only present if study level random effects are
#'   specified in the \code{jointmeta1} function call.}
#'
#'   \item{\code{log.like.long}}{the numeric value of the log likelihood for the
#'   initial longitudinal model.}
#'
#'   \item{\code{randstart.ind}}{a list of the conditional modes of the
#'   individual level random effects in each study given the data and the
#'   estimates of the separate longitudinal model parameters}
#'
#'   \item{\code{randstart.ind.cov}}{a list of the conditional covariance
#'   matrices for each individual for the individual level random effects given
#'   the data and the estimates of the separate longitudinal model parameters}
#'
#'   \item{\code{randstart.stud}}{a data frame containing the conditional modes
#'   of the study level random effects given the data and the estimates of the
#'   separate longitudinal model parameters.  This is only present if study
#'   level random effects were specified in the \code{jointmeta1} function call.
#'   }
#'
#'   \item{\code{randstart.stud.cov}}{a list of conditional covariance matrices
#'   for each study for the study level random effects given the data and the
#'   estimates of the separate longitudinal model parameters. This is only
#'   present if study level random effects were specified in the
#'   \code{jointmeta1} function call.}
#'
#'   \item{\code{modelfit}}{the initial longitudinal model fit.  The model has
#'   the same specification as the longitudinal sub-model for the joint model,
#'   fitted using the \code{\link[lme4]{lmer}} function from package
#'   \code{lme4}}
#'
#'   }}
#'
#'   \item{\code{survests}}{a list containing estimates from the initial
#'   survival fit.  The components of this list are: \describe{
#'
#'   \item{\code{beta2}}{vector of the estimates of the fixed effects included
#'   in the survival model.}
#'
#'   \item{\code{haz}}{if \code{strat = TRUE} then this is a list of numeric
#'   vectors of length equal to the number of studies in the dataset, giving the
#'   study specific baseline hazard.  If \code{strat = FALSE} then the baseline
#'   is not stratified by study, and this is one numeric vector giving the
#'   common baseline across studies.}
#'
#'   \item{\code{rs}}{a counter to indicate the last how many unique event times
#'   had occured by the individual's survival time - this is for use during
#'   further calculation in the joint model EM algorithm.  If a stratified
#'   baseline this is a list of numerical vectors, whereas if the baseline is
#'   not stratified this is a single numeric vector.}
#'
#'   \item{\code{sf}}{the unique event times observed in the dataset. If a
#'   stratified baseline this is a list of numerical vectors, whereas if the
#'   baseline is not stratified this is a single numeric vector. }
#'
#'   \item{\code{nev}}{a counter of the number of events that occur at each
#'   event time.If a stratified baseline this is a list of numerical vectors,
#'   whereas if the baseline is not stratified this is a single numeric vector.}
#'
#'   \item{\code{log.like.surv}}{a numeric containing two values, the
#'   log-likelihood with the initial values and the log-likelihood with the
#'   final values, see \code{\link[survival]{coxph.object}}}
#'
#'   \item{\code{modelfit}}{the initial survival model fit.  The model has the
#'   same specification as the survival sub-model for the joint model, fitted
#'   using the \code{\link[survival]{coxph}} function from package
#'   \code{survival}}
#'
#'   }}
#'
#'   }}
#'
#'   \item{\code{sep.loglik}}{a list containing the log-likelihoods estimated
#'   from the separate analyses.  It contains three elements, namely
#'   \code{seplhood} - the sum of the log-likelihoods from the separate
#'   longitudinal and the separate survival analyses, \code{sepy} - the
#'   log-likelihood from the separate longitudinal analysis, \code{sepn} - the
#'   log-likelihood from the separate survival analysis.}
#'
#'   \item{\code{data}}{the \code{\link[joineR]{jointdata}} object containing
#'   the data the joint model was fitted to}
#'
#'   \item{\code{call}}{the function call supplied to the \code{jointmeta1}
#'   function.}
#'
#'   \item{\code{numstudies}}{an integer containing the number of studies
#'   present in the data used to fit the joint model}
#'
#'   \item{\code{n.bystudy}}{a numeric vector containing the number of
#'   individuals present in each study in the data used to fit the joint model.
#'   This will be less than the number of individuals in the supplied dataset,
#'   if missing data is present in variables included in the model.}
#'
#'   \item{\code{missingids}}{the ids of any individuals excluded from the
#'   analysis due to missing data}
#'
#'   \item{\code{nobs}}{a table containing the number of longitudinal
#'   measurements supplied by each study in the data used to fit the model. This
#'   will be less than the number of longitudinal measurements in the dataset
#'   supplied to the function call, if missing data is present in variables
#'   included in the model}
#'
#'   }

"jointmeta1.object" <- NULL
