% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{onestage4}
\alias{onestage4}
\title{One stage jointmeta1 fit and bootstrapped standard errors}
\format{A list of 2 objects: \describe{ \item{\code{onestagefit4}}{an object
  of class \code{jointmeta1}} \item{\code{onestagefit4SE}}{an object of class
  \code{jointmeta1SE}} }}
\usage{
onestage4
}
\description{
A list of length two containing a one stage jointmeta1 fit and corresponding
bootstrapped standard errors.
}
\details{
These are the results of using the \code{jointmeta1} function to fit
  a one stage joint meta model for multi-study data, and also the bootstrap
  results of applying the \code{jointmetaSE} function to the resulting model
  fit. The data used is the \code{simdat2} data available in the
  \code{joineRmeta} package.  This data has three levels, namely the
  longitudinal measurements at level 1, nested within individuals (level 2)
  who are themselves nested within studies (level 3).

  The format of this model is as follows.  The structure of the longitudinal
  sub-model is:

  \deqn{Y_{kij} = \beta_{10} + \beta_{11}time + \beta_{12}treat +
  \beta_{13}study + b^{(2)}_{0ki} + b^{(2)}_{1ki}time + b^{(3)}_{1k}treat +
  \epsilon_{kij}}

  Where \eqn{Y_{kij}} represents the continuous longitudinal outcome for the
  \eqn{i}th individual in the \eqn{k}th study at the \eqn{j}th time point,
  fixed effect coefficients are represented by \eqn{\beta}, random effects
  coefficients by \eqn{b} and the measurement error by \eqn{\epsilon}.  For
  the  random effects the superscript of 2 indicates individual level, or
  level 2 random effects.  This means they take can take a unique value for
  each individual in the dataset. A superscript of 3 indicates study level
  random effects, or level 3 random effects.  This means that they can take a
  unique value for each study in the dataset. The longitudinal time variable
  is represented by \eqn{time}, and the treatment assignment variable (a
  binary factor) is represented by \eqn{treat}.  The study membership, a
  factor variable, is represented by \eqn{study}.

  The survival sub-model had format:

  \deqn{\lambda_{ki}(t) = \lambda_{0k}(t)exp(\beta_{21}treat +
  \alpha^{(2)}(b^{(2)}_{0ki} + b^{(2)}_{1ki}time) + \alpha^{(3)}(b^{(2)}_{0k}
  + b^{(3)}_{1k}treat)) }

  In the above equation, \eqn{\lambda_{ki}(t)} represents the survival time
  of the individual \eqn{i} in study \eqn{k}, and \eqn{\lambda_{0k}(t)}
  represents the unspecified baseline hazard which is stratified by study.
  The fixed effect coefficients are represented by \eqn{\beta} terms. A
  proportional random effects only association structure links the
  sub-models, with \eqn{\alpha^{(2)}} representing the association between
  the longitudinal and survival outcomes attributable to the deviation of the
  individual in question from the population mean longitudinal trajectory,
  and \eqn{\alpha^{(3)}} representing the association between the
  longitudinal and survival outcomes attributable to the deviation.

  We differentiate between the fixed effect coefficients in the longitudinal
  and the survival sub-models by varying the first number present in the
  subscript of the fixed effect, which takes a 1 for coefficients from the
  longitudinal sub-model and a 2 for coefficients from the survival
  sub-model.

  This model accounts for between study heterogeneity using study level
  random effects.

  These fits have been provided in this package for use with the package
  vignette, see the vignette for more information.

  The code used to fit this one stage model was:

  \code{ onestagefit4<-jointmeta1(data = jointdat, long.formula = Y ~ 1 +
  time + treat + study, long.rand.ind = c('int', 'time'), long.rand.stud =
  c('treat'), sharingstrct = 'randprop', surv.formula = Surv(survtime, cens)
  ~ treat, study.name = 'study', strat = T) }

  And the code used to bootstrap the model was:

  \code{ onestagefit4SE<-jointmetaSE(fitted = onestagefit4, n.boot = 200) }
}
\seealso{
\code{\link{jointmeta1}}, \code{\link{jointmetaSE}}
}
\keyword{datasets}
