% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general.R
\name{print.jointVIP}
\alias{print.jointVIP}
\title{Obtains a print for jointVIP object}
\usage{
\method{print}{jointVIP}(x, ..., smd = "OVB-based", use_abs = TRUE, bias_tol = 0.01)
}
\arguments{
\item{x}{a jointVIP object}

\item{...}{not used}

\item{smd}{specify the standardized mean difference is \code{OVB-based} or \code{standard}}

\item{use_abs}{TRUE (default) for absolute measures}

\item{bias_tol}{numeric 0.01 (default) any bias above the absolute bias_tol will be printed}
}
\value{
measures used to create the plot of jointVIP
}
\description{
Obtains a print for jointVIP object
}
\examples{
data <- data.frame(year = rnorm(50, 200, 5),
                   pop = rnorm(50, 1000, 500),
                   gdpPercap = runif(50, 100, 1000),
                   trt = rbinom(50, 1, 0.5),
                   out = rnorm(50, 1, 0.2))
# random 20 percent of control as pilot data                  
pilot_sample_num = sample(which(data$trt == 0),
                          length(which(data$trt == 0)) *
                          0.2)
pilot_df = data[pilot_sample_num, ]
analysis_df = data[-pilot_sample_num, ]
treatment = "trt"
outcome = "out"
covariates = names(analysis_df)[!names(analysis_df)
                                \%in\% c(treatment, outcome)]
new_jointVIP = create_jointVIP(treatment = treatment,
                               outcome = outcome,
                               covariates = covariates,
                               pilot_df = pilot_df,
                               analysis_df = analysis_df)
print(new_jointVIP)
}
