% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select.R
\name{select}
\alias{select}
\alias{select_}
\title{Select - filtering}
\usage{
select(.data, ...)

select_(.data, ..., .dots)
}
\arguments{
\item{.data}{input. This can be JSON input, or an object of class
\code{jqr} that has JSON and query params combined, which is passed
from function to function when using the jqr DSL.}

\item{...}{Comma separated list of unquoted variable names}

\item{.dots}{Used to work around non-standard evaluation}

\item{dots}{dots}
}
\description{
The function \code{select(foo)} produces its input unchanged if 
\code{foo} returns TRUE for that input, and produces no output otherwise
}
\note{
this function has changed what it does dramatically. we were 
using this function for object construction, which is now done with 
\code{\link{build_object}}
}
\examples{
jq('[1,5,3,0,7]', 'map(select(. >= 2))')
'[1,5,3,0,7]' \%>\% map(select(. >= 2)) 


'{"foo": 4, "bar": 7}' \%>\% select(.foo == 4)
'{"foo": 5, "bar": 7} {"foo": 4, "bar": 7}' \%>\% select(.foo == 4)
'[{"foo": 5, "bar": 7}, {"foo": 4, "bar": 7}]' \%>\% index() \%>\% 
  select(.foo == 4)
'{"foo": 4, "bar": 7} {"foo": 5, "bar": 7} {"foo": 8, "bar": 7}' \%>\% 
  select(.foo < 6)

x <- '{"foo": 4, "bar": 2} {"foo": 5, "bar": 4} {"foo": 8, "bar": 12}'
jq(x, 'select((.foo < 6) and (.bar > 3))')
jq(x, 'select((.foo < 6) or (.bar > 3))')
x \%>\% select((.foo < 6) && (.bar > 3))
x \%>\% select((.foo < 6) || (.bar > 3))

x <- '[{"foo": 5, "bar": 7}, {"foo": 4, "bar": 7}, {"foo": 4, "bar": 9}]'
jq(x, '.[] | select(.foo == 4) | {user: .bar}')
x \%>\% index() \%>\% select(.foo == 4) \%>\% build_object(user = .bar)
}
