% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip.R
\name{manip}
\alias{manip}
\alias{join}
\alias{join_}
\alias{splitj}
\alias{splitj_}
\alias{ltrimstr}
\alias{ltrimstr_}
\alias{rtrimstr}
\alias{rtrimstr_}
\alias{startswith}
\alias{startswith_}
\alias{endswith}
\alias{endswith_}
\alias{index_loc}
\alias{index_loc_}
\alias{rindex_loc}
\alias{rindex_loc_}
\alias{indices}
\alias{indices_}
\alias{tojson}
\alias{fromjson}
\alias{tostring}
\alias{tonumber}
\alias{contains}
\alias{contains_}
\alias{uniquej}
\alias{uniquej_}
\alias{group}
\alias{group_}
\title{Manipulation operations}
\usage{
join(.data, ...)

join_(.data, ..., .dots)

splitj(.data, ...)

splitj_(.data, ..., .dots)

ltrimstr(.data, ...)

ltrimstr_(.data, ..., .dots)

rtrimstr(.data, ...)

rtrimstr_(.data, ..., .dots)

startswith(.data, ...)

startswith_(.data, ..., .dots)

endswith(.data, ...)

endswith_(.data, ..., .dots)

index_loc(.data, ...)

index_loc_(.data, ..., .dots)

rindex_loc(.data, ...)

rindex_loc_(.data, ..., .dots)

indices(.data, ...)

indices_(.data, ..., .dots)

tojson(.data)

fromjson(.data)

tostring(.data)

tonumber(.data)

contains(.data, ...)

contains_(.data, ..., .dots)

uniquej(.data, ...)

uniquej_(.data, ..., .dots)

group(.data, ...)

group_(.data, ..., .dots)
}
\arguments{
\item{.data}{input. This can be JSON input, or an object of class
\code{jqr} that has JSON and query params combined, which is passed
from function to function when using the jqr DSL.}

\item{...}{Comma separated list of unquoted variable names}

\item{.dots}{Used to work around non-standard evaluation}

\item{dots}{dots}
}
\description{
Manipulation operations
}
\examples{
# join
str <- '["a","b,c,d","e"]'
jq(str, 'join(", ")')
str \%>\% join
str \%>\% join(`;`)
str \%>\% join(`yep`)
## many JSON inputs
'["a","b,c,d","e"] ["a","f,e,f"]' \%>\% join(`---`)

# split
jq('"a, b,c,d, e"', 'split(", ")')

# ltrimstr
jq('["fo", "foo", "barfoo", "foobar", "afoo"]', '[.[]|ltrimstr("foo")]')
'["fo", "foo", "barfoo", "foobar", "afoo"]' \%>\% index() \%>\% ltrimstr(foo)

# rtrimstr
jq('["fo", "foo", "barfoo", "foobar", "foob"]', '[.[]|rtrimstr("foo")]')
'["fo", "foo", "barfoo", "foobar", "foob"]' \%>\% index() \%>\% rtrimstr(foo)

# startswith
str <- '["fo", "foo", "barfoo", "foobar", "barfoob"]'
jq(str, '[.[]|startswith("foo")]')
str \%>\% index \%>\% startswith(foo)
## many JSON inputs
'["fo", "foo"] ["barfoo", "foobar", "barfoob"]' \%>\% index \%>\% startswith(foo)

# endswith
jq(str, '[.[]|endswith("foo")]')
str \%>\% index \%>\% endswith(foo)
str \%>\% index \%>\% endswith_("foo")
str \%>\% index \%>\% endswith(bar)
str \%>\% index \%>\% endswith_("bar")
## many JSON inputs
'["fo", "foo"] ["barfoo", "foobar", "barfoob"]' \%>\% index \%>\% endswith(foo)

# get index (location) of a character
## input has to be quoted
str <- '"a,b, cd, efg, hijk"'
str \%>\% index_loc(", ")
str \%>\% index_loc(",")
str \%>\% index_loc("j")
str \%>\% rindex_loc(", ")
str \%>\% indices(", ")

# tojson, fromjson, tostring, tonumber
'[1, "foo", ["foo"]]' \%>\% index \%>\% tostring
'[1, "1"]' \%>\% index \%>\% tonumber
'[1, "foo", ["foo"]]' \%>\% index \%>\% tojson
'[1, "foo", ["foo"]]' \%>\% index \%>\% tojson \%>\% fromjson

# contains
'"foobar"' \%>\% contains("bar")
'["foobar", "foobaz", "blarp"]' \%>\% contains(`["baz", "bar"]`)
'["foobar", "foobaz", "blarp"]' \%>\% contains(`["bazzzzz", "bar"]`)
str <- '{"foo": 12, "bar":[1,2,{"barp":12, "blip":13}]}'
str \%>\% contains(`{foo: 12, bar: [{barp: 12}]}`)
str \%>\% contains(`{foo: 12, bar: [{barp: 15}]}`)

# unique
'[1,2,5,3,5,3,1,3]' \%>\% uniquej
str <- '[{"foo": 1, "bar": 2}, {"foo": 1, "bar": 3}, {"foo": 4, "bar": 5}]'
str \%>\% uniquej(foo)
str \%>\% uniquej_("foo")
'["chunky", "bacon", "kitten", "cicada", "asparagus"]' \%>\% uniquej(length)

# group
x <- '[{"foo":1, "bar":10}, {"foo":3, "bar":100}, {"foo":1, "bar":1}]'
x \%>\% group(foo)
x \%>\% group_("foo")
}
