% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_mpd.R
\name{new_mpd}
\alias{new_mpd}
\title{Maximal Prime Decomposition}
\usage{
new_mpd(graph)
}
\arguments{
\item{graph}{Neighbor matrix}
}
\value{
- \code{prime_ints}: a list with the prime components,
- \code{flawed}: indicating which prime components that are triangulated
- \code{jt_collect}: the MPD junction tree prepared for collecting
}
\description{
Find the maximal prime decomposition and its associated junction tree
}
\examples{

library(igraph)
el <- matrix(c(
"A", "T",
"T", "E",
"S", "L",
"S", "B",
"L", "E",
"E", "X",
"E", "D",
"B", "D"),
 nc = 2,
 byrow = TRUE
)

g <- igraph::graph_from_edgelist(el, directed = FALSE)
A <- igraph::as_adjacency_matrix(g, sparse = FALSE)
new_mpd(A)

}
