% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jubilee-calc-cape-method.R
\name{jubilee.calc_cape}
\alias{jubilee.calc_cape}
\title{Internal utility to calculate n-year CAPE}
\usage{
jubilee.calc_cape(dtb, period, tol.frac = 1/6)
}
\arguments{
\item{dtb}{data.table}

\item{period}{numeric, the backward-looking regression period}

\item{tol.frac}{numeric, tolerance of missing data in the beginning of the time series,
expressed as fraction.
Default is 1/6, that is, two months.}
}
\value{
numeric, the same length as \code{dtb$fraction}.
}
\description{
This CAPE calculator replicates the methodology of Shiller, so that one can calculate
n-year CAPE, e.g. n=20.
This utility has been calibrated by original 10-year CAPE data from Shiller.
}
\examples{
  \dontrun{
    dtb <- jubilee.repo(online=FALSE)@ie
    cape10 <- jubilee.calc_cape(dtb, 10)
    cape20 <- jubilee.calc_cape(dtb, 20)
  }
}
\author{
Stephen H. Lihn
}
\keyword{utility}
