% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jubilee-mcsapply-method.R
\name{jubilee.mcsapply}
\alias{jubilee.mcsapply}
\title{Wrapper to calculate \code{sapply} using multi-core}
\usage{
jubilee.mcsapply(x, FUN, ...)
}
\arguments{
\item{x}{numeric}

\item{FUN}{the function to be applied to each element of x}

\item{...}{optional arguments to \code{FUN}}
}
\value{
numeric
}
\description{
This utility calculates \code{sapply} using multi-core capability. 
It is a simple wrapper on \code{simplify2array} and \code{parallel::mclapply}. 
It is particularly convenient on Linux and Mac when parallelism saves significant amount of computing time.
}
\examples{
   a <- seq(1,100)
   jubilee.mcsapply(a, function(x) x^2) # use multi-core!
}
\author{
Stephen H. Lihn
}
\keyword{utility}
