% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_mmrm.R
\name{summarize_mmrm}
\alias{summarize_mmrm}
\alias{s_summarize_mmrm}
\alias{a_summarize_mmrm}
\title{Dynamic tabulation of MMRM results with tables}
\usage{
s_summarize_mmrm(
  df,
  .var,
  variables,
  ref_levels,
  .spl_context,
  alternative = c("two.sided", "less", "greater"),
  show_relative = c("reduction", "increase"),
  ...
)

a_summarize_mmrm(
  df,
  .var,
  .spl_context,
  ...,
  .stats = NULL,
  .formats = NULL,
  .labels = NULL,
  .indent_mods = NULL
)
}
\arguments{
\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{.var}{(\code{string})\cr single variable name that is passed by \code{rtables} when requested
by a statistics function.}

\item{variables}{(named \code{list} of \code{string})\cr list of additional analysis variables.}

\item{ref_levels}{(\code{list})\cr with \code{visit} and \code{arm} reference levels.}

\item{.spl_context}{(\code{data.frame})\cr gives information about ancestor split states
that is passed by \code{rtables}.}

\item{alternative}{(\code{string})\cr whether \code{two.sided}, or one-sided \code{less} or \code{greater} p-value
should be displayed.}

\item{show_relative}{should the 'reduction' (\code{control - treatment}, default) or the 'increase'
(\code{treatment - control}) be shown for the relative change from baseline?}

\item{...}{eventually passed to \code{\link[=fit_mmrm_j]{fit_mmrm_j()}} via \code{\link[=h_summarize_mmrm]{h_summarize_mmrm()}}.}

\item{.stats}{(\code{character})\cr statistics to select for the table.}

\item{.formats}{(named \code{character} or \code{list})\cr formats for the statistics. See Details in \code{analyze_vars} for more
information on the \code{'auto'} setting.}

\item{.labels}{(named \code{character})\cr labels for the statistics (without indent).}

\item{.indent_mods}{(named \code{integer})\cr indent modifiers for the labels. Defaults to 0, which corresponds to the
unmodified default behavior. Can be negative.}
}
\value{
\itemize{
\item \code{a_summarize_mmrm()} returns the corresponding list with formatted \code{\link[rtables:CellValue]{rtables::CellValue()}}.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

These functions can be used to produce tables for MMRM results, within
tables which are split by arms and visits. This is helpful when higher-level
row splits are needed (e.g. splits by parameter or subgroup).
}
\section{Functions}{
\itemize{
\item \code{s_summarize_mmrm()}: Statistics function which is extracting estimates,
not including any results when in the reference visit, and only showing LS mean
estimates when in the reference arm and not in reference visit. It uses
\code{\link[=s_lsmeans]{s_lsmeans()}} for the final processing.

\item \code{a_summarize_mmrm()}: Formatted analysis function which is used as \code{afun}.

}}
\examples{
set.seed(123)
longdat <- data.frame(
  ID = rep(DM$ID, 5),
  AVAL = c(
    rep(0, nrow(DM)),
    rnorm(n = nrow(DM) * 4)
  ),
  VISIT = factor(rep(paste0("V", 0:4), each = nrow(DM)))
) |>
  dplyr::inner_join(DM, by = "ID")

basic_table() |>
  split_rows_by("VISIT") |>
  split_cols_by("ARM") |>
  analyze(
    vars = "AVAL",
    afun = a_summarize_mmrm,
    na_str = tern::default_na_str(),
    show_labels = "hidden",
    extra_args = list(
      variables = list(
        covariates = c("AGE"),
        id = "ID",
        arm = "ARM",
        visit = "VISIT"
      ),
      conf_level = 0.9,
      cor_struct = "toeplitz",
      ref_levels = list(VISIT = "V0", ARM = "B: Placebo")
    )
  ) |>
  build_table(longdat) |>
  prune_table(all_zero)
}
