% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_backcrossing.R
\name{sim_backcrossing}
\alias{sim_backcrossing}
\title{Function to simulate data using a back crossing scheme}
\usage{
sim_backcrossing(
  population_size = 100,
  freq_ancestor_1 = 0.5,
  total_runtime = 5,
  size_in_morgan = 1,
  number_of_markers = 100,
  seed = 6,
  time_points = -1
)
}
\arguments{
\item{population_size}{Population size}

\item{freq_ancestor_1}{Frequency of ancestor 1 at t = 0}

\item{total_runtime}{Number of generations to simulate}

\item{size_in_morgan}{Mean number of crossovers per meiosis (e.g. size in
Morgan of the chromosome)}

\item{number_of_markers}{number of molecular markers}

\item{seed}{Seed of the pseudo-random number generator}

\item{time_points}{vector with time points at which local ancestry has to be
recorded to be returned at the end of the simulation. If left at -1,
ancestry is recorded at every generation (computationally heavy).}
}
\value{
List with five entries: average_junctions: average number of
junctions over time, detected_junctions: average number of detected
junctions, given the markers. markers: vector with the locations of the
molecular markers, junction_distribution: distribution of junctions per
time step average_heterozygosity: average heterozygosity.
}
\description{
Individual based simulation of the accumulation of junctions,
under a back crossing scheme
}
\examples{
sim_backcrossing(population_size = 100,
                       total_runtime = 5,
                       size_in_morgan = 1, number_of_markers = 100, seed = 6,
                       time_points = 1:5)
}
