# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

get_cpplib <- function() {
    .Call(`_jwutil_get_cpplib`)
}

getOmpMaxThreads <- function() {
    .Call(`_jwutil_getOmpMaxThreads`)
}

getOmpThreads <- function() {
    .Call(`_jwutil_getOmpThreads`)
}

#' @name isRowSorted
#' @title is every row sorted?
#' @description Quicky run through rows of a matrix looking for any
#' non-ascending rows in C++
#' @param x matrix, each row containing ordered or disordered numerics
#' @export
isRowSorted <- function(x) {
    .Call(`_jwutil_isRowSorted`, x)
}

#' @name propRowSorted
#' @title proportion of non-descending rows in matrix
#' @description first performs isRowSorted to get a logical vector,
#' then sums TRUE values and takes fraction of total
#' @param x matrix, each row containing ordered or disordered numerics
#' @return double, the proportion from 0 to 1
#' @export
propRowSorted <- function(x) {
    .Call(`_jwutil_propRowSorted`, x)
}

stdlib_gnu <- function() {
    .Call(`_jwutil_stdlib_gnu`)
}

stdlib_llvm <- function() {
    .Call(`_jwutil_stdlib_llvm`)
}

#' @name fastIntToString
#' @title Fast convert integer vector to character vector
#' @description Fast conversion from integer vector to character vector using C++
#' @param x vector of integers
#' @param bufferSize int if any input strings are longer than this number
#'   (default 16) there will be memory errors. No checks done for speed.
#' @examples
#' \dontrun{
#' pts <- generate_random_pts(1e7)
#' # conclusion: buffer size matters little (so default to be more generous),
#' # and Rcpp version fastest.
#' microbenchmark::microbenchmark(fastIntToStringStd(pts$visit_id, buffer = 8),
#'                                fastIntToStringStd(pts$visit_id, buffer = 16),
#'                                fastIntToStringStd(pts$visit_id, buffer = 64),
#'                                fastIntToStringRcpp(pts$visit_id, buffer = 8),
#'                                fastIntToStringRcpp(pts$visit_id, buffer = 16),
#'                                fastIntToStringRcpp(pts$visit_id, buffer = 64),
#'                                as.character(pts$visit_id),
#'                                as_char_no_warn(pts$visit_id), times = 5)
#' }
#' @keywords internal
fastIntToStringStd <- function(x) {
    .Call(`_jwutil_fastIntToStringStd`, x)
}

#' @title Convert integers to strings as quickly as possible
#' @description Have tried R, `sprintf` with \pkg{Rcpp} and C++ standard
#' library. Doesn't do bounds checking, but limited by length of integers.
#' @param x Vector of integers
#' @return Vector of characters
#' @md
#' @keywords internal manip
fastIntToStringRcpp <- function(x) {
    .Call(`_jwutil_fastIntToStringRcpp`, x)
}

