% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/aoristic.R
\docType{methods}
\name{plot_aoristic}
\alias{plot_aoristic}
\alias{autoplot,AoristicSum-method}
\alias{plot,AoristicSum,missing-method}
\alias{autoplot,RateOfChange-method}
\alias{plot,RateOfChange,missing-method}
\title{Plot Aoristic Analysis}
\usage{
\S4method{autoplot}{AoristicSum}(object, ..., facet = TRUE)

\S4method{plot}{AoristicSum,missing}(x, facet = TRUE, ...)

\S4method{autoplot}{RateOfChange}(object, ..., level = 0.95, facet = TRUE)

\S4method{plot}{RateOfChange,missing}(x, level = 0.95, facet = TRUE, ...)
}
\arguments{
\item{object, x}{An \linkS4class{AoristicSum} object.}

\item{...}{Currently not used.}

\item{facet}{A \code{\link{logical}} scalar: should a matrix of panels defined by
groups be drawn?}

\item{level}{A length-one \code{\link{numeric}} vector giving the confidence level.}
}
\value{
\itemize{
\item \code{autoplot()} returns a \code{\link[ggplot2:ggplot]{ggplot}} object.
\item \code{plot()} is called it for its side-effects: it results in a graphic being
displayed (invisibly returns \code{x}).
}
}
\description{
Plot Aoristic Analysis
}
\examples{
## Aoristic Analysis
data("loire", package = "folio")

## Get time range
loire_range <- loire[, c("lower", "upper")]

## Calculate aoristic sum (normal)
aorist_raw <- aoristic(loire_range, step = 50, weight = FALSE)
plot(aorist_raw)

## Calculate aoristic sum (weights)
aorist_weighted <- aoristic(loire_range, step = 50, weight = TRUE)
plot(aorist_weighted)

## Calculate aoristic sum (weights) by group
aorist_groups <- aoristic(loire_range, step = 50, weight = TRUE,
                          groups = loire$area)
plot(aorist_groups)

## Rate of change
roc_weighted <- roc(aorist_weighted, n = 30)
plot(roc_weighted)

## Rate of change by group
roc_groups <- roc(aorist_groups, n = 30)
plot(roc_groups)
}
\seealso{
\code{\link[=aoristic]{aoristic()}}, \code{\link[=roc]{roc()}}

Other plotting methods: 
\code{\link{plot_event}},
\code{\link{plot_fit}},
\code{\link{plot_mcd}},
\code{\link{plot_time}()}
}
\author{
N. Frerebeau
}
\concept{plotting methods}
