% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kaya.R
\name{get_fuel_mix}
\alias{get_fuel_mix}
\title{Get fuel mix for a country or region}
\usage{
get_fuel_mix(region_name, collapse_renewables = TRUE, quiet = FALSE,
  region_code = NULL)
}
\arguments{
\item{region_name}{The name of a country or region to look up}

\item{collapse_renewables}{Combine hydroelectricity and other renewables into
a single category.}

\item{quiet}{Suppress warnings if there is no data for that country or
region.}

\item{region_code}{Optional three-letter country or region code to look up
instead of the `region_name`}
}
\value{
a tibble of fuel mix for the country or region.
  That is, the number of quads of each fuel and the
  fraction of total primary energy coming from that fuel.
}
\description{
Get fuel mix for a country or region
}
\examples{
get_fuel_mix("United States")
get_fuel_mix("World", collapse_renewables = FALSE)
get_fuel_mix(region_code = "LCN")
}
