% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kaya.R
\name{generation_capacity}
\alias{generation_capacity}
\title{Get power output from generation sources}
\usage{
generation_capacity()
}
\value{
a tibble of values for generation sources
\describe{
    \item{fuel}{Energy source: Coal, Nuclear, Gas, Solar Thermal, or Wind}
    \item{description}{Text description of the power source}
    \item{nameplate_capacity}{Maximum sustained power output, in megawatts}
    \item{capacity_factor}{Capacity factor: the fraction of the nameplate
        capacity that the plant can provide, averaged over a typical year}
}
}
\description{
Nameplate capacity and capacity factors for different electrical generation
technologies. The average power supplied over a year is the nameplate
capacity times the capacity factor.
}
\details{
Data for fossil fuels comes from EIA
}
\examples{
gc <- generation_capacity()
gc
}
\references{
Environmental Protection Agency (2018) "Electric Power Monthly,"
(October 2018) \url{https://www.eia.gov/electricity/monthly/current_month/epm.pdf},
\href{https://www.eia.gov/electricity/monthly/epm_table_grapher.php?t=epmt_6_07_a}{Table 6.7.A}.

Pielke, Jr., Roger A., \emph{The Climate Fix} (Basic Books, 2010).
}
