% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layer-methods.R
\name{quantize_weights}
\alias{quantize_weights}
\title{Quantize the weights of a model.}
\usage{
quantize_weights(object, mode)
}
\arguments{
\item{object}{A Keras Model or Layer.}

\item{mode}{The mode of the quantization. Only 'int8' is supported at this
time.}
}
\value{
\code{model}, invisibly. Note this is just a convenience for usage with \verb{|>}, the
model is modified in-place.
}
\description{
Note that the model must be built first before calling this method.
\code{quantize_weights()} will recursively call \code{layer$quantize(mode)} in all layers and
will be skipped if the layer doesn't implement the function.

Currently only \code{Dense} and \code{EinsumDense} layers support quantization.
}
\seealso{
Other layer methods: \cr
\code{\link{count_params}()} \cr
\code{\link{get_config}()} \cr
\code{\link{get_weights}()} \cr
\code{\link{reset_state}()} \cr
}
\concept{layer methods}
