% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Loss.R
\name{Loss}
\alias{Loss}
\title{Subclass the base \code{Loss} class}
\usage{
Loss(
  classname,
  call = NULL,
  ...,
  public = list(),
  private = list(),
  inherit = NULL,
  parent_env = parent.frame()
)
}
\arguments{
\item{classname}{String, the name of the custom class. (Conventionally, CamelCase).}

\item{call}{\if{html}{\out{<div class="sourceCode r">}}\preformatted{function(y_true, y_pred)
}\if{html}{\out{</div>}}

Method to be implemented by subclasses:
Function that contains the logic for loss calculation using
\code{y_true}, \code{y_pred}.}

\item{..., public}{Additional methods or public members of the custom class.}

\item{private}{Named list of R objects (typically, functions) to include in
instance private environments. \code{private} methods will have all the same
symbols in scope as public methods (See section "Symbols in Scope"). Each
instance will have it's own \code{private} environment. Any objects
in \code{private} will be invisible from the Keras framework and the Python
runtime.}

\item{inherit}{What the custom class will subclass. By default, the base keras class.}

\item{parent_env}{The R environment that all class methods will have as a grandparent.}
}
\value{
A function that returns \code{Loss} instances, similar to the
builtin loss functions.
}
\description{
Use this to define a custom loss class. Note, in most cases you do not need
to subclass \code{Loss} to define a custom loss: you can also pass a bare R
function, or a named R function defined with \code{\link[=custom_metric]{custom_metric()}}, as a loss
function to \code{compile()}.
}
\details{
Example subclass implementation:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{loss_custom_mse <- Loss(
  classname = "CustomMeanSquaredError",
  call = function(y_true, y_pred) \{
    op_mean(op_square(y_pred - y_true), axis = -1)
  \}
)

# Usage in compile()
model <- keras_model_sequential(input_shape = 10) |> layer_dense(10)
model |> compile(loss = loss_custom_mse())

# Standalone usage
mse <- loss_custom_mse(name = "my_custom_mse_instance")

y_true <- op_arange(20) |> op_reshape(c(4, 5))
y_pred <- op_arange(20) |> op_reshape(c(4, 5)) * 2
(loss <- mse(y_true, y_pred))
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## tf.Tensor(123.5, shape=(), dtype=float32)

}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{loss2 <- (y_pred - y_true)^2 |>
  op_mean(axis = -1) |>
  op_mean()

stopifnot(all.equal(as.array(loss), as.array(loss2)))

sample_weight <-array(c(.25, .25, 1, 1))
(weighted_loss <- mse(y_true, y_pred, sample_weight = sample_weight))
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## tf.Tensor(112.8125, shape=(), dtype=float32)

}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{weighted_loss2 <- (y_true - y_pred)^2 |>
  op_mean(axis = -1) |>
  op_multiply(sample_weight) |>
  op_mean()

stopifnot(all.equal(as.array(weighted_loss),
                    as.array(weighted_loss2)))
}\if{html}{\out{</div>}}
}
\section{Methods defined by base \code{Loss} class:}{
\itemize{
\item

\if{html}{\out{<div class="sourceCode r">}}\preformatted{initialize(name=NULL, reduction="sum_over_batch_size", dtype=NULL)
}\if{html}{\out{</div>}}

Args:
\itemize{
\item \code{name}: Optional name for the loss instance.
\item \code{reduction}: Type of reduction to apply to the loss. In almost all cases
this should be \code{"sum_over_batch_size"}.
Supported options are \code{"sum"}, \code{"sum_over_batch_size"} or \code{NULL}.
\item \code{dtype}: The dtype of the loss's computations. Defaults to \code{NULL}, which
means using \code{\link[=config_floatx]{config_floatx()}}. \code{config_floatx()} is a
\code{"float32"} unless set to different value
(via \code{\link[=config_set_floatx]{config_set_floatx()}}). If a \code{keras$DTypePolicy} is
provided, then the \code{compute_dtype} will be utilized.
}
\item

\if{html}{\out{<div class="sourceCode">}}\preformatted{__call__(y_true, y_pred, sample_weight=NULL)
}\if{html}{\out{</div>}}

Call the loss instance as a function, optionally with \code{sample_weight}.
\item

\if{html}{\out{<div class="sourceCode r">}}\preformatted{get_config()
}\if{html}{\out{</div>}}
}
}

\section{Readonly properties:}{
\itemize{
\item

\if{html}{\out{<div class="sourceCode r">}}\preformatted{dtype
}\if{html}{\out{</div>}}
}
}

\section{Symbols in scope}{
All R function custom methods (public and private) will have the
following symbols in scope:
\itemize{
\item \code{self}: The custom class instance.
\item \code{super}: The custom class superclass.
\item \code{private}: An R environment specific to the class instance.
Any objects assigned here are invisible to the Keras framework.
\item \verb{__class__} and \code{as.symbol(classname)}: the custom class type object.
}
}

\seealso{
Other losses: \cr
\code{\link{loss_binary_crossentropy}()} \cr
\code{\link{loss_binary_focal_crossentropy}()} \cr
\code{\link{loss_categorical_crossentropy}()} \cr
\code{\link{loss_categorical_focal_crossentropy}()} \cr
\code{\link{loss_categorical_hinge}()} \cr
\code{\link{loss_cosine_similarity}()} \cr
\code{\link{loss_ctc}()} \cr
\code{\link{loss_dice}()} \cr
\code{\link{loss_hinge}()} \cr
\code{\link{loss_huber}()} \cr
\code{\link{loss_kl_divergence}()} \cr
\code{\link{loss_log_cosh}()} \cr
\code{\link{loss_mean_absolute_error}()} \cr
\code{\link{loss_mean_absolute_percentage_error}()} \cr
\code{\link{loss_mean_squared_error}()} \cr
\code{\link{loss_mean_squared_logarithmic_error}()} \cr
\code{\link{loss_poisson}()} \cr
\code{\link{loss_sparse_categorical_crossentropy}()} \cr
\code{\link{loss_squared_hinge}()} \cr
\code{\link{loss_tversky}()} \cr
\code{\link{metric_binary_crossentropy}()} \cr
\code{\link{metric_binary_focal_crossentropy}()} \cr
\code{\link{metric_categorical_crossentropy}()} \cr
\code{\link{metric_categorical_focal_crossentropy}()} \cr
\code{\link{metric_categorical_hinge}()} \cr
\code{\link{metric_hinge}()} \cr
\code{\link{metric_huber}()} \cr
\code{\link{metric_kl_divergence}()} \cr
\code{\link{metric_log_cosh}()} \cr
\code{\link{metric_mean_absolute_error}()} \cr
\code{\link{metric_mean_absolute_percentage_error}()} \cr
\code{\link{metric_mean_squared_error}()} \cr
\code{\link{metric_mean_squared_logarithmic_error}()} \cr
\code{\link{metric_poisson}()} \cr
\code{\link{metric_sparse_categorical_crossentropy}()} \cr
\code{\link{metric_squared_hinge}()} \cr
}
\concept{losses}
