% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callbacks.R
\name{TensorBoard}
\alias{TensorBoard}
\title{Tensorboard basic visualizations.}
\usage{
TensorBoard(log_dir = "./logs", histogram_freq = 0, write_graph = TRUE,
  write_images = FALSE)
}
\arguments{
\item{log_dir}{the path of the directory where to save the log files
to be parsed by Tensorboard.}

\item{histogram_freq}{frequency (in epochs) at which to compute activation
histograms for the layers of the model. If set to
0, histograms won't be computed.}

\item{write_graph}{whether to visualize the graph in Tensorboard. The
log file can become quite large when write_graph
is set to True.}

\item{write_images}{whether to write model weights to visualize as
image in Tensorboard.}
}
\description{
This callback writes a log for TensorBoard, which allows you to visualize
dynamic graphs of your training and test metrics, as well as activation
histograms for the different layers in your model.
}
\references{
Chollet, Francois. 2015. \href{https://keras.io/}{Keras: Deep Learning library for Theano and TensorFlow}.
}
\author{
Taylor B. Arnold, \email{taylor.arnold@acm.org}
}
