% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dens.par.R
\name{dens.par}
\alias{dens.par}
\title{Non-separable adaptive spatio-temporal intensity estimator}
\usage{
dens.par(
  X,
  t = NULL,
  dimyx = 128,
  dimt = 128,
  bw.xy = NULL,
  bw.t = NULL,
  ngroups.xy = NULL,
  ngroups.t = NULL,
  at = c("bins", "points")
)
}
\arguments{
\item{X}{A spatial point pattern (an object of class \code{ppp}) with the spatial coordinates of the observations. It may contain marks representing times.}

\item{t}{A numeric vector of temporal coordinates with equal length to the number of points in \code{X}. This gives the time associated with each spatial point. This argument is not necessary if time marks are provided to the point pattern \code{X}.}

\item{dimyx}{Spatial pixel resolution. The default is 128 for each axes.}

\item{dimt}{Temporal bin vector dimension. The default is 128.}

\item{bw.xy}{Numeric vector of spatial smoothing bandwidths for each point in \code{X}. By default this is computed using \link[spatstat.explore]{bw.abram}.}

\item{bw.t}{Numeric vector of temporal smoothing bandwidths for each point in \code{t}. By default this is computed using \link{bw.abram.temp}.}

\item{ngroups.xy}{Number of groups in which the spatial bandwidths should be partitioned. If this number is 1, then a classical non-adaptive estimator will be used for the spatial part with a bandwidth selected as the median of the bw.xy vector.}

\item{ngroups.t}{Number of groups in which the temporal bandwidths should be partitioned. If this number is 1, then a classical non-adaptive estimator will be used for the temporal part with a bandwidth selected as the median of the bw.t vector.}

\item{at}{String specifying whether to estimate the intensity at a mesh (\code{at = "bins"}) or only at the points of \code{X} (\code{at = "points"}).}
}
\value{
If \code{at = "points"} (the default), the result is a numeric vector with one entry for each data point in \code{X}. if \code{at = "bins"} is a list named (by time-point) list of pixel images (\link[spatstat.geom]{im} objects) corresponding to the joint spatio-temporal intensity over space at each discretised time bin.
}
\description{
Provides an adaptive-bandwidth kernel estimate for spatio-temporal point patterns in a non-separable fashion by using binning of the bandwidth values.
}
\details{
This function computes a non-separable spatio-temporal adaptive kernel estimate of the intensity. It starts from a planar point pattern \code{X} and a vector of times \code{t} and partition (cells) the spatial and temporal components to apply a non-separable kernel estimator within each cell.
The arguments \code{bw.xy} and \code{bw.t} specify the smoothing bandwidth vectors to be applied to each of the points in \code{X} and \code{t}. They should be a numeric vectors of bandwidths.
The method partition the range of bandwidths into intervals, subdividing the points of the pattern \code{X} and \code{t} into sub-patterns according to the bandwidths, and applying fixed-bandwidth smoothing to each sub-pattern. Specifying \code{ngroups.xy = 1} is the same as fixed-bandwidth smoothing with bandwidth \code{sigma = median(bw.xy)} in the spatial case and \code{ngroups.t = 1} is the same as fixed-bandwidth smoothing with bandwidth \code{sigma = median(bw.xy)}.
}
\examples{
data(lGCpp)
stIntensity <- dens.par(lGCpp, dimt = 16)
plot(spatstat.geom::as.solist(stIntensity[13:16]), ncols = 4,
     main = 'Non-separable Example', equal.ribbon = TRUE)

}
\references{
González J.A. and Moraga P. (2018)
An adaptive kernel estimator for the intensity function of spatio-temporal point processes
\url{https://arxiv.org/pdf/2208.12026.pdf}
}
\author{
Jonatan A. González
}
