% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keyed-df.R
\name{keyed-df}
\alias{keyed-df}
\alias{is_keyed_df}
\alias{is.keyed_df}
\alias{print.keyed_df}
\alias{[.keyed_df}
\title{Keyed object}
\usage{
is_keyed_df(.tbl)

is.keyed_df(.tbl)

\method{print}{keyed_df}(x, ...)

\method{[}{keyed_df}(x, i, j, ...)
}
\arguments{
\item{.tbl}{Object to check.}

\item{x}{Object to print or extract elements.}

\item{...}{Further arguments passed to or from other methods.}

\item{i, j}{Arguments for \code{\link{[}}.}
}
\description{
Utility functions for keyed objects which are implemented with class
\code{keyed_df}. Keyed object should be a data frame which inherits from
\code{keyed_df} and contains a data frame of \link[=keys-set]{keys} in attribute 'keys'.
}
\examples{
is_keyed_df(mtcars)

mtcars \%>\% key_by(vs) \%>\% is_keyed_df

# Not valid keyed_df
df <- mtcars
class(df) <- c("keyed_df", "data.frame")
is_keyed_df(df)

}
