% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_colour_science.R
\name{scale_colour_stratigraphy}
\alias{scale_colour_stratigraphy}
\alias{scale_color_stratigraphy}
\alias{scale_fill_stratigraphy}
\alias{scale_edge_colour_stratigraphy}
\alias{scale_edge_color_stratigraphy}
\alias{scale_edge_fill_stratigraphy}
\title{Geologic Timescale Color Scheme for \pkg{ggplot2} and \pkg{ggraph}}
\usage{
scale_colour_stratigraphy(..., lang = "en", aesthetics = "colour")

scale_color_stratigraphy(..., lang = "en", aesthetics = "colour")

scale_fill_stratigraphy(..., lang = "en", aesthetics = "fill")

scale_edge_colour_stratigraphy(..., lang = "en")

scale_edge_color_stratigraphy(..., lang = "en")

scale_edge_fill_stratigraphy(..., lang = "en")
}
\arguments{
\item{...}{Arguments passed on to \code{\link[ggplot2:discrete_scale]{ggplot2::discrete_scale()}}.}

\item{lang}{A \code{\link{character}} string specifying the language for the
color names (see details). It must be one of "\code{en}" (english, the
default), "\code{fr}" (french) or \code{NULL}. If not \code{NULL}, the values will be
matched based on the color names.}

\item{aesthetics}{A \code{\link{character}} string or vector of character
strings listing the name(s) of the aesthetic(s) that this scale works with.}
}
\value{
A \link[ggplot2:discrete_scale]{discrete} scale.
}
\description{
Provides the geologic timescale color scheme.
}
\details{
Values will be matched based on the geological unit names.
}
\examples{
library(ggplot2)

strati <- data.frame(
  name = c("Phanerozoic", "Paleozoic", "Cambrian", "Ordovician", "Silurian",
           "Devonian", "Carboniferous", "Mesozoic", "Triassic", "Cretaceous",
           "Jurassic", "Cenozoic", "Paleogene", "Neogene", "Quaternary"),
  type = c("Eon", "Era", "Period", "Period", "Period", "Period", "Period",
           "Era", "Period", "Period", "Period", "Era", "Period", "Period",
           "Period"),
  start = c(541, 541, 541, 485, 444, 419, 359,
            252, 252, 201, 145, 66, 66, 23, 2.6),
  end = c(0, 252, 485, 444, 419, 359, 252,
          66, 201, 145, 66, 2.6, 23, 2.6, 0)
)

## Keep chronological order in the legend
strati$name <- factor(strati$name, levels = rev(unique(strati$name)),
                      ordered = TRUE)

## Workaround: use `limits = force` to remove unused values
ggplot2::ggplot(strati) +
  ggplot2::geom_rect(ggplot2::aes(xmin = rep(0, 15), xmax = rep(1, 15),
                                  ymin = start, ymax = end, fill = name)) +
  ggplot2::scale_y_reverse() +
  ggplot2::facet_grid(. ~ type) +
  scale_fill_stratigraphy(name = "Stratigraphy", limits = force)
}
\references{
\href{https://ccgm.org/}{Commission for the Geological Map of the World}.
}
\seealso{
Other themed color schemes: 
\code{\link{scale_colour_land}()},
\code{\link{scale_colour_soil}()}

Other qualitative color schemes: 
\code{\link{scale_colour_land}()},
\code{\link{scale_colour_soil}()},
\code{\link{scale_okabeito_discrete}},
\code{\link{scale_tol_bright}},
\code{\link{scale_tol_dark}},
\code{\link{scale_tol_discreterainbow}},
\code{\link{scale_tol_highcontrast}},
\code{\link{scale_tol_light}},
\code{\link{scale_tol_mediumcontrast}},
\code{\link{scale_tol_muted}},
\code{\link{scale_tol_pale}},
\code{\link{scale_tol_vibrant}}
}
\author{
N. Frerebeau
}
\concept{qualitative color schemes}
\concept{themed color schemes}
