% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot2-science.R
\name{scale_colour_soil}
\alias{scale_colour_soil}
\alias{scale_color_soil}
\alias{scale_fill_soil}
\title{FAO Soil Reference Groups Colour Scheme for \pkg{ggplot2}}
\usage{
scale_colour_soil(..., aesthetics = "colour")

scale_color_soil(..., aesthetics = "colour")

scale_fill_soil(..., aesthetics = "fill")
}
\arguments{
\item{...}{Arguments passed on to \code{\link[ggplot2]{discrete_scale}}.}

\item{aesthetics}{A \code{\link{character}} string or vector of character
strings listing the name(s) of the aesthetic(s) that this scale works with.}
}
\value{
A \code{\link[ggplot2:discrete_scale]{discrete}} scale.
}
\description{
Provides the FAO Soil Reference Groups colour scheme.
}
\details{
Values will be matched based on the soil names.
}
\examples{
library(ggplot2)

soil <- data.frame(
  name = c(
    "Acrisol", "Albeluvisol", "Andosol", "Anthrosol", "Arenosol", "Calcisol",
    "Cambisol", "Chernozem", "Cryosol", "Fluvisol", "Kastanozem", "Gleysol",
    "Gypsisol", "Histosol", "Leptosol", "Luvisol", "Phaeozem", "Planosol",
    "Podzol", "Regosol", "Solonchak", "Solonetz", "Umbrisol", "Vertisol"
  )
)

ggplot2::ggplot(soil, ggplot2::aes(fill = name)) +
  ggplot2::geom_rect(aes(xmin = rep(0, 24), xmax = rep(1, 24),
                         ymin = 1:24, ymax = 1:24+1)) +
  ggplot2::scale_y_reverse() +
  scale_fill_soil(name = "Soil")
}
\references{
Jones, A., Montanarella, L. & Jones, R. (Ed.) (2005). \emph{Soil atlas of
 Europe}. Luxembourg: European Commission, Office for Official Publications
 of the European Communities. 128 pp. ISBN: 92-894-8120-X.
}
\seealso{
Other Themed colour schemes: \code{\link{scale_colour_land}},
  \code{\link{scale_colour_stratigraphy}}
}
\author{
N. Frerebeau
}
\concept{Themed colour schemes}
