% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/egfr_mdrd.R
\name{egfr.mdrd4}
\alias{egfr.mdrd4}
\title{Calculate estimated glomerular filtration rate (eGFR) by MDRD equation}
\usage{
egfr.mdrd4(
  creatinine,
  age,
  sex,
  ethnicity,
  creatinine_units = "micromol/l",
  creatinine_method = "non-IDMS",
  label_afroamerican = c("Afroamerican"),
  label_sex_male = c("Male", 1),
  label_sex_female = c("Female", 0),
  max_age = 100
)
}
\arguments{
\item{creatinine}{Numeric vector. Serum creatinine, could be expressed in "micromol/L", "mmol/L" or "mg/dL". Units of measurement should be defined in variable creatinine_units (if not defined explicitly by user, the default value is "micromol/L").}

\item{age}{Numeric vector. Age, in years.}

\item{sex}{Vector. The value of variable refers to the parameters label_sex_male and label_sex_female.}

\item{ethnicity}{Vector. Ethnicity, specify in case of African-American patients. The value of variable refers to the parameter label_afroamerican.}

\item{creatinine_units}{Character string. Units in which serum creatinne is expressed. Could be one of the following: "micromol/L", "mmol/L" or "mg/dL".}

\item{creatinine_method}{Character string. Creatinine standartisation method in a laboratory. Could be either "IDMS" or "non-IDMS". If not explicitly defined by user, the default assumption is "non-IDMS".}

\item{label_afroamerican}{List. Label(s) for Afroamerican ethnicity.}

\item{label_sex_male}{List. Label(s) for definition(s) of male sex.}

\item{label_sex_female}{List. Label(s) for definition(s) of female sex.}

\item{max_age}{Numeric. Maximal age suitable for the equation application, in years. By default is 100 years, but change this value in case you would like to apply equation to older persons.}
}
\value{
numeric eGFR expressed in ml/min/1.73m\ifelse{html}{\out{<sup>2</sup>}}{\eqn{^2}}.
}
\description{
Calculate estimated glomerular filtration rate (eGFR) by MDRD equation
}
\details{
Calculate estimated glomerular filtration rate (eGFR) by MDRD equation.

Reference to the equation: Levey AS, Coresh J, Greene T, et al. Using standardized serum creatinine values in the modification of diet in renal disease study equation for estimating glomerular filtration rate. Annals of Internal Medicine 2006;145:247–54.

Citation: Bikbov B. kidney.epi: Kidney-Related Functions for Clinical and Epidemiological Research. Scientific-Tools.Org, https://Scientific-Tools.Org. DOI: 10.32614/CRAN.package.kidney.epi
}
\examples{
# for a single patient
egfr.mdrd4 (creatinine = 1.4, age = 60, sex = "Male", ethnicity = "White",
  creatinine_units = "mg/dl")
# for a dataset - see vignettes for details
# egfr.mdrd4 (creatinine = dta$scr, age = dta$age, sex = dta$sex,
#  ethnicity = dta$race, creatinine_units = "mg/dl")
}
\author{
Programming: Boris Bikbov https://www.linkedin.com/in/boris-bikbov.
}
