% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_duplicates.R
\name{find_duplicates}
\alias{find_duplicates}
\title{Find duplicated values in a vector}
\usage{
find_duplicates(vector = NULL, na.rm = TRUE, sigfigs = 2, output = "summary")
}
\arguments{
\item{vector}{a vector whose elements will be checked for duplicates}

\item{na.rm}{logical. If \code{na.rm = TRUE}, NA values in the vector
will be removed before searching for duplicates.
If \code{na.rm = FALSE}, NA values will be included in the search
as potentially duplicated values. By default, \code{na.rm = TRUE}.}

\item{sigfigs}{number of significant digits to round to in
the percent column of the summary (default = 2)}

\item{output}{type of output. If \code{output = "summary"}, the function's
output will be a data.table summarizing duplicated values and
their counts. If \code{output = "duplicated_values"}, the function's
output will be a vector of duplicated values.
If \code{output = "non_duplicated_values"}, the function's output will
be a vector of non-duplicated values (default = "summary")}
}
\value{
the output will be a data.table object (summary),
a vector of duplicated values, or a vector non-duplicated values.
}
\description{
Find duplicated values in a vector
}
\examples{
find_duplicates(mtcars$cyl)
find_duplicates(mtcars$cyl, output = "duplicated_values")
find_duplicates(vector = c(mtcars$cyl, 11:20, NA, NA))
find_duplicates(vector = c(mtcars$cyl, 11:20, NA, NA), na.rm = FALSE)
find_duplicates(vector = c(mtcars$cyl, 11:20, NA, NA),
na.rm = FALSE, sigfigs = 4, output = "duplicated_values")
}
