% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alpha_constants.R
\name{alpha_constants}
\alias{alpha_constants}
\alias{alpha_constants.default}
\title{Calculate any constants depending on effective stress coefficient \eqn{\alpha}}
\usage{
alpha_constants(alpha = 0, c.type = c("Phi", "Psi", "A", "Kel"))

\method{alpha_constants}{default}(alpha = 0, c.type = c("Phi", "Psi",
  "A", "Kel"))
}
\arguments{
\item{alpha}{the constant alpha (see \code{\link{omega_constants}})}

\item{c.type}{the constant to calculate}
}
\value{
Complex matrix having values representing the constant 
represented by \code{c.type}, 
\emph{as well as} any other \eqn{\alpha}-dependent constants 
which are needed in the computation.
}
\description{
This function accesses the appropriate method to calculate the
\eqn{\alpha}-dependent constant associated with the choice of \code{c.type}.  
There are currently four such constants, which correspond to
\strong{Equations 10, 11, 18, 19} in Kitagawa et al (2011).

\emph{This function is not likely to be needed by the user.}
}
\details{
\subsection{What is \code{"alpha"}?}{
The constant \eqn{\alpha} is a function of frequency \eqn{\omega} as well 
as aquifer and well parameters; it is formally defined as
\deqn{\alpha \equiv R_S \sqrt{\omega S / T}}
where \eqn{S} is the storativity, \eqn{T} is the aquifer's effective
transmissivity, and \eqn{R_S} is the radius of the screened portion
of the well.
}
\subsection{What is calculated?}{
The various constants which may be calculated with this function are
\describe{
  \item{\code{Phi}}{Given as \eqn{\Phi} in Eqn. 10}
  \item{\code{Psi}}{Given as \eqn{\Psi} in Eqn. 11}
  \item{\code{A}}{Given as \eqn{A_i, i=1,2} in Eqns. 18, 19}
  \item{\code{Kel}}{The complex Kelvin functions (see Abramowitz and Stegun, 1972)}
}
}
}
\examples{
alpha_constants()   # kelvin::Keir gives warning
alpha_constants(1)  # defaults to constant 'Phi' (note output also has Kel)
alpha_constants(1:10, c.type="A")  # constant 'A' (again, note output)
}
\seealso{
\code{\link{omega_constants}}, \code{\link{well_response}}

Other ConstantsCalculators: \code{\link{kitagawa-constants}},
  \code{\link{omega_constants}}
}
\author{
A. J. Barbour <andy.barbour@gmail.com>
}
\concept{ConstantsCalculators}
