% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ki_timeseries_values.R
\name{ki_timeseries_values}
\alias{ki_timeseries_values}
\title{Get values for time series id or list of time series ids.}
\usage{
ki_timeseries_values(hub, ts_id, start_date, end_date)
}
\arguments{
\item{hub}{The KiWIS database you are querying. Either one of the defaults or a URL.
See \href{https://github.com/rywhale/kiwisR}{README}.}

\item{ts_id}{Either: a single time series id or a vector of time series ids.
Time series ids can be found using the ki_timeseries_list function}

\item{start_date}{A date string formatted "YYYY-MM-DD". Defaults to yesterday.}

\item{end_date}{A date string formatted "YYYY-MM-DD". Defaults to today.}
}
\value{
Either: a single tibble or a list of tibbles (each named according to station and parameter).
 Tibbles returned contain columns for Timestamp, Value and Unit. All timestamps are returned in UTC.
}
\description{
Returns time series values for given time series id and date range.
}
\examples{
ki_timeseries_values(
  hub = "kisters",
  ts_id = "231042",
  start_date = "2015-12-01",
  end_date = "2018-01-01"
  )

}
