% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knn_distances.R
\name{knn_distances}
\alias{knn_distances}
\title{Distances matrixes computation and saving in files with a maximum of columns}
\usage{
knn_distances(y, d, distance_metric = "euclidean", threads = NULL, file,
  cols = 1)
}
\arguments{
\item{y}{A time series.}

\item{d}{Values of d's to be analyzed.}

\item{distance_metric}{Type of metric to evaluate the distance between points. Many metrics are supported: euclidean, manhattan,
dynamic time warping, canberra and others. For more information about the supported metrics check the values that 'method'
argument of function 'parDist' (from 'parallelDist' package) can take as this is the function used to calculate the distances.
Link to the package info: \url{https://cran.r-project.org/package=parallelDist}.
Some of the values that this argument can take are "euclidean", "manhattan", "dtw", "canberra", "chord".}

\item{threads}{Number of threads to be used when parallelizing distances calculation, default is number of cores detected - 1 or
1 if there is only one core.}

\item{file}{Path and id of the files where the distances matrixes will be saved.}

\item{cols}{Number of columns per file.}
}
\description{
Calculates one distances matrix per each d for the given time series and then save them in files. Each file will
contain a maximum of 'cols' number of columns from the corresponding distances matrix.
}
\examples{
knn_distances(AirPassengers, 1:3, threads = 2, file = "AirPassengers", cols = 2)
knn_distances(LakeHuron, 1:6, threads = 2, file = "LakeHuron", cols = 10)
}
