% Generated by roxygen2 (4.0.2): do not edit by hand
\name{knockoff.stat.fs}
\alias{knockoff.stat.fs}
\alias{knockoff.stat.fs_omp}
\title{Knockoff filter forward selection statistics}
\usage{
knockoff.stat.fs(X, X_ko, y)

knockoff.stat.fs_omp(X, X_ko, y)
}
\arguments{
\item{X}{original design matrix}

\item{X_ko}{knockoff matrix}

\item{y}{response vector}
}
\value{
The statistic W
}
\description{
Computes the statistic
  \deqn{W_j = \max(Z_j, Z_{j+p}) \cdot \mathrm{sgn}(Z_j - Z_{j+p}),}
where \eqn{Z_1,\dots,Z_{2p}} give the reverse order in which the 2p
variables (the originals and the knockoffs) enter the forward selection
model. See the Details for information about forward selection.
}
\details{
In \emph{forward selection}, the variables are chosen iteratively to maximize
the inner product with the residual from the previous step. The initial
residual is always \code{y}. In standard forward selection
(\code{knockoff.stats.fs}), the next residual is the remainder after
regressing on the selected variable; when \emph{orthogonal matching pursuit}
is used (\code{knockoff.stats.fs_omp}), the next residual is the remainder
after regressing on \emph{all} the previously selected variables.
}

