% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_method_filterByClass.R
\docType{methods}
\name{filterByClass}
\alias{filterByClass}
\alias{filterByClass,kRp.text-method}
\title{Remove word classes}
\usage{
filterByClass(txt, ...)

\S4method{filterByClass}{kRp.text}(
  txt,
  corp.rm.class = "nonpunct",
  corp.rm.tag = c(),
  as.vector = FALSE,
  update.desc = TRUE
)
}
\arguments{
\item{txt}{An object of class \code{\link[koRpus:kRp.text-class]{kRp.text}}.}

\item{...}{Additional options, currently unused.}

\item{corp.rm.class}{A character vector with word classes which should be removed. The default value
\code{"nonpunct"} has special meaning and will cause the result of
\code{kRp.POS.tags(lang, tags=c("punct","sentc"), list.classes=TRUE)} to be used.
Another valid value is "stopword" to remove all detected stopwords.}

\item{corp.rm.tag}{A character vector with valid POS tags which should be removed.}

\item{as.vector}{Logical. If \code{TRUE},
      results will be returned as a character vector containing only the text parts
which survived the filtering.}

\item{update.desc}{Logical. If \code{TRUE},
      the \code{desc} slot of the tagged object will be fully recalculated
using the filtered text. If \code{FALSE},
      the \code{desc} slot will be copied from the original object.
Finally, if \code{NULL}, the \code{desc} slot remains empty.}
}
\value{
An object of the input class. If \code{as.vector=TRUE}, returns only a character vector.
}
\description{
This method strips off defined word classes of tagged text objects.
}
\examples{
\dontrun{
   filterByClass(tagged.text)
}
}
\seealso{
\code{\link[koRpus:kRp.POS.tags]{kRp.POS.tags}}
}
\keyword{misc}
