\name{kobeMFCL}
\alias{kobeMFCL}
\title{Reads Multifan-CL assessment results and returns stock and harvest rate relative to MSY reference points}
\usage{
  kobeMFCL(object,dir="",
           what=c("sims","trks","pts","smry","wrms")[1], prob=c(0.75,0.5,0.25),ptYrs=NULL,nwrms=10)
}
\arguments{
  \item{object}{character: rep file with results.}

  \item{dir}{character; optional argument identifying directory where file is.}

  \item{what}{character; specifies the form of data returned.}
  
  \item{prob}{numeric; probabilities with values in [0,1] for percentiles returned if \code{what["trks"]} selected.}

  \item{ptYrs}{numeric; year(s) for points if \code{what["pts"]} selected.}

  \item{nwrms}{numeric; number of trajectories sampled at random to return if \code{what["wrms"]} selected.}
}
\description{Reads in text file generated by MFCL and returns time series or summaries of B:BMSY and F:FMSY.
  \code{what} specifies how data are returned, i.e. \code{sims} bootstraps for all years; \code{trks} percentiles given by \code{prob};
\code{pts} selected year(s) given by \code{ptYrs}; \code{smRY} probabilities of being in the kobe quadrants and; \code{wrms} bootstraps selected at random. 
If of length 1 then a data.frame is returned, if >1 then a list of data.frames.
}
\examples{

\dontrun{

kobeMFCL("bft")
}

}
\seealso{
  \code{\link{kobeAspic}},\code{\link{kobe2box}},\code{\link{kobeMFCL}},\code{\link{kobeSS3}}
}

