% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getKSJURL.R
\name{getKSJURL}
\alias{getKSJURL}
\title{getKSJURL API}
\usage{
getKSJURL(identifier, prefCode = NULL, meshCode = NULL, metroArea = NULL,
  fiscalyer = NULL, appId = "ksjapibeta1", lang = "J", dataformat = 1)
}
\arguments{
\item{identifier}{Data identifier. (e.g. \code{"N02"})}

\item{prefCode}{Prefecture code. You can easily get the codes by using \code{\link{choose_prefecture_code}}.
This is valid only when \code{areaType} is \code{3}.}

\item{meshCode}{Mesh code. This is valid only when \code{areaType} is \code{4}.}

\item{metroArea}{Metro-area code. This is valid only when \code{areaType} is \code{2}.}

\item{fiscalyer}{Fiscal year. (e.g. \code{"2014"}, \code{"2014,2015"}, \code{"2005-2015"}, \code{"2000,2005-2015"})}

\item{appId}{Application ID. Currently, no per-user appId is proveded. \code{"ksjapibeta1"} is the only choice.}

\item{lang}{Language. Currently \code{J} (Japansese) is the only choice.}

\item{dataformat}{Data format. Currently \code{1} (JPGIS2.1) is the only choice.}
}
\description{
Get the URLs of the data via Kokudo Suuchi API.
}
\examples{
\dontrun{
getKSJURL("W05", prefCode = c(27, 28))
getKSJURL("W05", prefCode = choose_prefecture_code())
}

}
\seealso{
\url{http://nlftp.mlit.go.jp/ksj/api/about_api.html}
}

