% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VisualizationFunctions.R
\name{plot_sample_velocity}
\alias{plot_sample_velocity}
\title{Plot the sample-to-sample velocity of eye tracking data.}
\usage{
plot_sample_velocity(
  data_in,
  velocity.filter.ms = 20,
  plot.window = c(NA, NA),
  xcol = "x.raw",
  ycol = "y.raw",
  threshold.line = NA,
  one_degree = 40,
  verbose = TRUE
)
}
\arguments{
\item{data_in}{Data frame with gaze data to plot. Include the variable timestamp with timing in ms and columns with raw
x and y data as specified by the paramerers xcol and ycol or their default values}

\item{velocity.filter.ms}{Window in milliseconds for moving average window used for smoothing the sample-to-sample velocity vector.}

\item{plot.window}{vector defining the time window to plot. If left empty, the 50-65% interval of the data are plotted. If the submitted values are
<0, they are assumed to be proportions, e.g., plot.window = c(0.3,0.35) plots the 30-35 percent of max.length interval of the data. Numbers >1 are assumed to refer to sample order
in the data}

\item{xcol}{Name of the column where raw x values are stored. Default: "x.raw"}

\item{ycol}{Name of the column where raw y values are stored. Default: "y.raw"}

\item{threshold.line}{Can be specified to add a line showing a potential velocity threshold for saccade detection. No threshold is shown if this parameter is NA}

\item{one_degree}{One degree of the visual field in the unit of the raw x and y coordinates, typically pixels}

\item{verbose}{If TRUE, print the resulting plot}
}
\value{
A ggplot showing the sample-to-sample velocity of the selected data interval
}
\description{
This function visualizes the sample-to-sample velocity in a period of eye tracking data. This can be helpful when determining a suitable velocity threshold for saccade detection
Input data must be a data frame with the variables timestamp, x.raw and y.raw as variables. Other variables can
be included but will be ignored. This function does not perform pre-processing in the form of interpolation or smoothing. Use the function process.gaze for this.
Timestamps are assumed to be in milliseconds. Default settings assume that x and y coordinates are in pixels.
The output data is a plot of sample-to-sample velocity in the selected interval.
}
\examples{
plot_sample_velocity(data_in = sample.data.processed, threshold.line = 35)

}
