% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/krippendorff.R
\name{plot.krippendorffsalpha}
\alias{plot.krippendorffsalpha}
\title{Plot the results of a Krippendorff's Alpha analysis.}
\usage{
\method{plot}{krippendorffsalpha}(
  x,
  y = NULL,
  level = 0.95,
  type = 7,
  density = TRUE,
  lty.density = 1,
  lty.estimate = 1,
  lty.interval = 2,
  col.density = "black",
  col.estimate = "orange",
  col.interval = "blue",
  lwd.density = 3,
  lwd.estimate = 3,
  lwd.interval = 3,
  ...
)
}
\arguments{
\item{x}{an object of class \code{"krippendorffsalpha"}, the result of a call to \code{\link{krippendorffs.alpha}}.}

\item{y}{always ignored.}

\item{level}{the desired confidence level for the interval. The default is 0.95.}

\item{type}{the method used to compute sample quantiles. This argument is passed to \code{\link{quantile}}. The default is 7.}

\item{density}{logical; if \code{TRUE}, a kernel density estimate is plotted.}

\item{lty.density}{the line type for the kernel density estimate. The default is 1.}

\item{lty.estimate}{the line type for the estimate of alpha. The default is 1.}

\item{lty.interval}{the line type for the confidence limits. The default is 2.}

\item{col.density}{the color for the kernel density estimate. The default is black.}

\item{col.estimate}{the color for the estimate of alpha. The default is orange.}

\item{col.interval}{the color for the confidence limits. The default is blue.}

\item{lwd.density}{the line width for the kernel density estimate. The default is 3.}

\item{lwd.estimate}{the line width for the estimate of alpha. The default is 3.}

\item{lwd.interval}{the line width for the confidence limits. The default is 3.}

\item{\dots}{additional arguments. These are passed to \code{\link{hist}}.}
}
\description{
Plot the results of a Krippendorff's Alpha analysis.
}
\details{
This function plots the results of a Krippendorff's Alpha analysis, assuming that \code{\link{krippendorffs.alpha}} was called with \code{confint = TRUE}.
}
\examples{
# The following data were presented in Krippendorff (2013).

nominal = matrix(c(1,2,3,3,2,1,4,1,2,NA,NA,NA,
                   1,2,3,3,2,2,4,1,2,5,NA,3,
                   NA,3,3,3,2,3,4,2,2,5,1,NA,
                   1,2,3,3,2,4,4,1,2,5,1,NA), 12, 4)
fit.nom = krippendorffs.alpha(nominal, level = "nominal", confint = TRUE, verbose = TRUE,
                              control = list(bootit = 1000, parallel = FALSE))
dev.new()
plot(fit.nom, main = "Results for Nominal Data", xlab = "Bootstrap Estimates", density = FALSE)
}
\references{
Krippendorff, K. (2013). Computing Krippendorff's alpha-reliability. Technical report, University of Pennsylvania.
}
