% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variableKey.R
\name{keyCrossRef}
\alias{keyCrossRef}
\title{keyCrossRef}
\usage{
keyCrossRef(key, ignoreClass = NULL, verbose = FALSE, lowercase = FALSE)
}
\arguments{
\item{key}{A variable key, ideally a long key. If a wide key is
provided it is converted to long.}

\item{ignoreClass}{Classes that should be excluded from
check. Useful when many integer variables are being reverse-
coded. Takes a string or vector.}

\item{verbose}{Should a statement about the number of issues
detected be returned? Defaults to FALSE.}

\item{lowercase}{Should old and new values be passed through
tolower function? Defaults to FALSE.}
}
\value{
Presents a warning for potentially problematic key
    sections. Return is dependent on verbose argument.
}
\description{
Checks a key for dangerous matches of old and new values in a key
for different levels.
}
\details{
Positions in a long key are referred to as levels. If a value is
mismatched at levels 1 and 3, this means that issues are in rows 1
and 3 of the section of the given variable in a long key.
}
\examples{
dat <- data.frame(x1 = sample(c("a", "b", "c", "d"), 100, replace = TRUE),
                  x2 = sample(c("Apple", "Orange"), 100, replace = TRUE),
                  x3 = ordered(sample(c("low", "medium", "high"), 100, replace = TRUE),
                  levels = c("low", "medium", "high")),
                  stringsAsFactors = FALSE)
key <- keyTemplate(dat, long = TRUE)
## No errors with a fresh key.
kutils:::keyCrossRef(key, verbose = TRUE)
key[1:2, "value_new"] <- c("b", "a")
key[5, "value_new"]
key[7:9, "value_new"] <- c("high", "medium", "low")
kutils:::keyCrossRef(key)
kutils:::keyCrossRef(key, ignoreClass = c("ordered", "character"), verbose = TRUE)
}
\author{
Ben Kite <bakite@ku.edu>
}
