% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PenOpt.R
\name{PenOpt}
\alias{PenOpt}
\title{Solve the internal minimization problem}
\usage{
PenOpt(U, n, elements, iteration, pen, k)
}
\arguments{
\item{U}{The eigenvector matrix.}

\item{n}{The number of nodes of the connected component to cluster.}

\item{elements}{The representative elements of the connected component to cluster.}

\item{iteration}{The cluster we aim at recovering.}

\item{pen}{The penalty (to be chosen among "lasso" and "thresholdedLS").}

\item{k}{The number of clusters.}
}
\value{
\code{v} The community indicator of cluster \code{iteration}.
}
\description{
This internal function of the l1-spectral clustering algorithm solves the l1-minimization problem and recover the community indicators of the clusters.
}
\examples{
 ###################################
 # Solving the minimization problem
 ###################################

 # 1st: create data
 Data <- CreateDataSet(k=3, n=20, p=list(p_inside=0.1,p_outside=0.1))

 # 2nd: find the structure, the opt number of clusters and the representative elements
 Structure <- FindStructure(Data$A_hat)
 Clusters <- FindNbrClusters(A = Data$A_hat, structure = Structure)
 Elements <- FindElement(A = Data$A_hat, structure = Structure, clusters = Clusters)

 Structure_tmp <- Structure$groups[[1]] # the first component
 A_tmp <- Data$A_hat[Structure$groups[[1]],Structure$groups[[1]]]
 n <- ncol(A_tmp)
 k <- Clusters$nbr_clusters$Component1 # number of clusters to create
 Elements_tmp <- Elements$indices$Component1 # the elements of the first component

 # 3rd: perform svd
 svd <- eigen(A_tmp)
 eigenvalues <- sort(svd$values,index.return=TRUE)
 eigenvectors <- svd$vectors[,eigenvalues$ix]

 # 4th: solve the minimization problem
 i <- 1 # the cluster we aim at recovering
 U <- t(eigenvectors[,1:(n-k+i-1)])
 v <- PenOpt(U, n, elements = Elements_tmp, iteration = i, pen = "lasso", k) # for lasso

 # the same with the least-squared threshold
 \donttest{v <- PenOpt(U, n, elements = Elements_tmp, iteration = i, pen = "thresholdedLS", k)}
}
\seealso{
\code{\link{l1_spectralclustering}}, \code{\link{l1_spectral}}, \code{\link{l1spectral}}.
}
\author{
Camille Champion, Magali Champion
}
\keyword{internal}
